package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Edge;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * All attributes associated to the Edge
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * container edge-attributes {
 *   uses edge-attributes;
 * }
 * </pre>
 * <p>To create instances of this class use {@link EdgeAttributesBuilder}.
 * @see EdgeAttributesBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface EdgeAttributes
    extends
    ChildOf<Edge>,
    Augmentable<EdgeAttributes>,
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("edge-attributes");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.EdgeAttributes> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.EdgeAttributes.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.@NonNull EdgeAttributes obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAdjSid());
        result = prime * result + Objects.hashCode(obj.getAdminGroup());
        result = prime * result + Objects.hashCode(obj.getAvailableBandwidth());
        result = prime * result + Objects.hashCode(obj.getBackupAdjSid());
        result = prime * result + Objects.hashCode(obj.getDelay());
        result = prime * result + Objects.hashCode(obj.getJitter());
        result = prime * result + Objects.hashCode(obj.getLocalAddress());
        result = prime * result + Objects.hashCode(obj.getLocalIdentifier());
        result = prime * result + Objects.hashCode(obj.getLoss());
        result = prime * result + Objects.hashCode(obj.getMaxLinkBandwidth());
        result = prime * result + Objects.hashCode(obj.getMaxResvLinkBandwidth());
        result = prime * result + Objects.hashCode(obj.getMetric());
        result = prime * result + Objects.hashCode(obj.getMinMaxDelay());
        result = prime * result + Objects.hashCode(obj.getRemoteAddress());
        result = prime * result + Objects.hashCode(obj.getRemoteIdentifier());
        result = prime * result + Objects.hashCode(obj.getResidualBandwidth());
        result = prime * result + Objects.hashCode(obj.getSrlgs());
        result = prime * result + Objects.hashCode(obj.getTeMetric());
        result = prime * result + Objects.hashCode(obj.getUnreservedBandwidth());
        result = prime * result + Objects.hashCode(obj.getUtilizedBandwidth());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.@NonNull EdgeAttributes thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.EdgeAttributes other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.EdgeAttributes.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAdjSid(), other.getAdjSid())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAdminGroup(), other.getAdminGroup())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAvailableBandwidth(), other.getAvailableBandwidth())) {
            return false;
        }
        if (!Objects.equals(thisObj.getBackupAdjSid(), other.getBackupAdjSid())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDelay(), other.getDelay())) {
            return false;
        }
        if (!Objects.equals(thisObj.getJitter(), other.getJitter())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLocalIdentifier(), other.getLocalIdentifier())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLoss(), other.getLoss())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMaxLinkBandwidth(), other.getMaxLinkBandwidth())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMaxResvLinkBandwidth(), other.getMaxResvLinkBandwidth())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMetric(), other.getMetric())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRemoteIdentifier(), other.getRemoteIdentifier())) {
            return false;
        }
        if (!Objects.equals(thisObj.getResidualBandwidth(), other.getResidualBandwidth())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTeMetric(), other.getTeMetric())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUtilizedBandwidth(), other.getUtilizedBandwidth())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLocalAddress(), other.getLocalAddress())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMinMaxDelay(), other.getMinMaxDelay())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRemoteAddress(), other.getRemoteAddress())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSrlgs(), other.getSrlgs())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUnreservedBandwidth(), other.getUnreservedBandwidth())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.@NonNull EdgeAttributes obj) {
        final var helper = MoreObjects.toStringHelper("EdgeAttributes");
        CodeHelpers.appendValue(helper, "adjSid", obj.getAdjSid());
        CodeHelpers.appendValue(helper, "adminGroup", obj.getAdminGroup());
        CodeHelpers.appendValue(helper, "availableBandwidth", obj.getAvailableBandwidth());
        CodeHelpers.appendValue(helper, "backupAdjSid", obj.getBackupAdjSid());
        CodeHelpers.appendValue(helper, "delay", obj.getDelay());
        CodeHelpers.appendValue(helper, "jitter", obj.getJitter());
        CodeHelpers.appendValue(helper, "localAddress", obj.getLocalAddress());
        CodeHelpers.appendValue(helper, "localIdentifier", obj.getLocalIdentifier());
        CodeHelpers.appendValue(helper, "loss", obj.getLoss());
        CodeHelpers.appendValue(helper, "maxLinkBandwidth", obj.getMaxLinkBandwidth());
        CodeHelpers.appendValue(helper, "maxResvLinkBandwidth", obj.getMaxResvLinkBandwidth());
        CodeHelpers.appendValue(helper, "metric", obj.getMetric());
        CodeHelpers.appendValue(helper, "minMaxDelay", obj.getMinMaxDelay());
        CodeHelpers.appendValue(helper, "remoteAddress", obj.getRemoteAddress());
        CodeHelpers.appendValue(helper, "remoteIdentifier", obj.getRemoteIdentifier());
        CodeHelpers.appendValue(helper, "residualBandwidth", obj.getResidualBandwidth());
        CodeHelpers.appendValue(helper, "srlgs", obj.getSrlgs());
        CodeHelpers.appendValue(helper, "teMetric", obj.getTeMetric());
        CodeHelpers.appendValue(helper, "unreservedBandwidth", obj.getUnreservedBandwidth());
        CodeHelpers.appendValue(helper, "utilizedBandwidth", obj.getUtilizedBandwidth());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

