package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.DecimalBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Delay;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Loss;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.MinMaxDelay;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.UnreservedBandwidth;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link EdgeAttributes} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     EdgeAttributes createEdgeAttributes(int fooXyzzy, int barBaz) {
 *         return new EdgeAttributesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of EdgeAttributes, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see EdgeAttributes
 *
 */
@Generated("mdsal-binding-generator")
public class EdgeAttributesBuilder {

    private Uint32 _adjSid;
    private Uint32 _adminGroup;
    private DecimalBandwidth _availableBandwidth;
    private Uint32 _backupAdjSid;
    private Delay _delay;
    private Delay _jitter;
    private IpAddress _localAddress;
    private Uint32 _localIdentifier;
    private Loss _loss;
    private DecimalBandwidth _maxLinkBandwidth;
    private DecimalBandwidth _maxResvLinkBandwidth;
    private Uint32 _metric;
    private MinMaxDelay _minMaxDelay;
    private IpAddress _remoteAddress;
    private Uint32 _remoteIdentifier;
    private DecimalBandwidth _residualBandwidth;
    private Set<Uint32> _srlgs;
    private Uint32 _teMetric;
    private List<UnreservedBandwidth> _unreservedBandwidth;
    private DecimalBandwidth _utilizedBandwidth;


    Map<Class<? extends Augmentation<EdgeAttributes>>, Augmentation<EdgeAttributes>> augmentation = Collections.emptyMap();

    public EdgeAttributesBuilder() {
    }
    
    
    
    public EdgeAttributesBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes arg) {
        this._metric = arg.getMetric();
        this._teMetric = arg.getTeMetric();
        this._adminGroup = arg.getAdminGroup();
        this._localAddress = arg.getLocalAddress();
        this._remoteAddress = arg.getRemoteAddress();
        this._localIdentifier = arg.getLocalIdentifier();
        this._remoteIdentifier = arg.getRemoteIdentifier();
        this._maxLinkBandwidth = arg.getMaxLinkBandwidth();
        this._maxResvLinkBandwidth = arg.getMaxResvLinkBandwidth();
        this._unreservedBandwidth = arg.getUnreservedBandwidth();
        this._delay = arg.getDelay();
        this._minMaxDelay = arg.getMinMaxDelay();
        this._jitter = arg.getJitter();
        this._loss = arg.getLoss();
        this._residualBandwidth = arg.getResidualBandwidth();
        this._availableBandwidth = arg.getAvailableBandwidth();
        this._utilizedBandwidth = arg.getUtilizedBandwidth();
        this._adjSid = arg.getAdjSid();
        this._backupAdjSid = arg.getBackupAdjSid();
        this._srlgs = arg.getSrlgs();
    }

    public EdgeAttributesBuilder(EdgeAttributes base) {
        Map<Class<? extends Augmentation<EdgeAttributes>>, Augmentation<EdgeAttributes>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._adjSid = base.getAdjSid();
        this._adminGroup = base.getAdminGroup();
        this._availableBandwidth = base.getAvailableBandwidth();
        this._backupAdjSid = base.getBackupAdjSid();
        this._delay = base.getDelay();
        this._jitter = base.getJitter();
        this._localAddress = base.getLocalAddress();
        this._localIdentifier = base.getLocalIdentifier();
        this._loss = base.getLoss();
        this._maxLinkBandwidth = base.getMaxLinkBandwidth();
        this._maxResvLinkBandwidth = base.getMaxResvLinkBandwidth();
        this._metric = base.getMetric();
        this._minMaxDelay = base.getMinMaxDelay();
        this._remoteAddress = base.getRemoteAddress();
        this._remoteIdentifier = base.getRemoteIdentifier();
        this._residualBandwidth = base.getResidualBandwidth();
        this._srlgs = base.getSrlgs();
        this._teMetric = base.getTeMetric();
        this._unreservedBandwidth = base.getUnreservedBandwidth();
        this._utilizedBandwidth = base.getUtilizedBandwidth();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes) {
            this._metric = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getMetric();
            this._teMetric = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getTeMetric();
            this._adminGroup = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getAdminGroup();
            this._localAddress = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getLocalAddress();
            this._remoteAddress = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getRemoteAddress();
            this._localIdentifier = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getLocalIdentifier();
            this._remoteIdentifier = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getRemoteIdentifier();
            this._maxLinkBandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getMaxLinkBandwidth();
            this._maxResvLinkBandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getMaxResvLinkBandwidth();
            this._unreservedBandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getUnreservedBandwidth();
            this._delay = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getDelay();
            this._minMaxDelay = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getMinMaxDelay();
            this._jitter = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getJitter();
            this._loss = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getLoss();
            this._residualBandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getResidualBandwidth();
            this._availableBandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getAvailableBandwidth();
            this._utilizedBandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getUtilizedBandwidth();
            this._adjSid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getAdjSid();
            this._backupAdjSid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getBackupAdjSid();
            this._srlgs = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getSrlgs();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes]");
    }

    public Uint32 getAdjSid() {
        return _adjSid;
    }
    
    public Uint32 getAdminGroup() {
        return _adminGroup;
    }
    
    public DecimalBandwidth getAvailableBandwidth() {
        return _availableBandwidth;
    }
    
    public Uint32 getBackupAdjSid() {
        return _backupAdjSid;
    }
    
    public Delay getDelay() {
        return _delay;
    }
    
    public Delay getJitter() {
        return _jitter;
    }
    
    public IpAddress getLocalAddress() {
        return _localAddress;
    }
    
    public Uint32 getLocalIdentifier() {
        return _localIdentifier;
    }
    
    public Loss getLoss() {
        return _loss;
    }
    
    public DecimalBandwidth getMaxLinkBandwidth() {
        return _maxLinkBandwidth;
    }
    
    public DecimalBandwidth getMaxResvLinkBandwidth() {
        return _maxResvLinkBandwidth;
    }
    
    public Uint32 getMetric() {
        return _metric;
    }
    
    public MinMaxDelay getMinMaxDelay() {
        return _minMaxDelay;
    }
    
    public IpAddress getRemoteAddress() {
        return _remoteAddress;
    }
    
    public Uint32 getRemoteIdentifier() {
        return _remoteIdentifier;
    }
    
    public DecimalBandwidth getResidualBandwidth() {
        return _residualBandwidth;
    }
    
    public Set<Uint32> getSrlgs() {
        return _srlgs;
    }
    
    public Uint32 getTeMetric() {
        return _teMetric;
    }
    
    public List<UnreservedBandwidth> getUnreservedBandwidth() {
        return _unreservedBandwidth;
    }
    
    public DecimalBandwidth getUtilizedBandwidth() {
        return _utilizedBandwidth;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<EdgeAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public EdgeAttributesBuilder setAdjSid(final Uint32 value) {
        this._adjSid = value;
        return this;
    }
    
    public EdgeAttributesBuilder setAdminGroup(final Uint32 value) {
        this._adminGroup = value;
        return this;
    }
    
    public EdgeAttributesBuilder setAvailableBandwidth(final DecimalBandwidth value) {
        this._availableBandwidth = value;
        return this;
    }
    
    public EdgeAttributesBuilder setBackupAdjSid(final Uint32 value) {
        this._backupAdjSid = value;
        return this;
    }
    
    public EdgeAttributesBuilder setDelay(final Delay value) {
        this._delay = value;
        return this;
    }
    
    public EdgeAttributesBuilder setJitter(final Delay value) {
        this._jitter = value;
        return this;
    }
    
    public EdgeAttributesBuilder setLocalAddress(final IpAddress value) {
        this._localAddress = value;
        return this;
    }
    
    public EdgeAttributesBuilder setLocalIdentifier(final Uint32 value) {
        this._localIdentifier = value;
        return this;
    }
    
    public EdgeAttributesBuilder setLoss(final Loss value) {
        this._loss = value;
        return this;
    }
    
    public EdgeAttributesBuilder setMaxLinkBandwidth(final DecimalBandwidth value) {
        this._maxLinkBandwidth = value;
        return this;
    }
    
    public EdgeAttributesBuilder setMaxResvLinkBandwidth(final DecimalBandwidth value) {
        this._maxResvLinkBandwidth = value;
        return this;
    }
    
    public EdgeAttributesBuilder setMetric(final Uint32 value) {
        this._metric = value;
        return this;
    }
    
    public EdgeAttributesBuilder setMinMaxDelay(final MinMaxDelay value) {
        this._minMaxDelay = value;
        return this;
    }
    
    public EdgeAttributesBuilder setRemoteAddress(final IpAddress value) {
        this._remoteAddress = value;
        return this;
    }
    
    public EdgeAttributesBuilder setRemoteIdentifier(final Uint32 value) {
        this._remoteIdentifier = value;
        return this;
    }
    
    public EdgeAttributesBuilder setResidualBandwidth(final DecimalBandwidth value) {
        this._residualBandwidth = value;
        return this;
    }
    public EdgeAttributesBuilder setSrlgs(final Set<Uint32> values) {
        this._srlgs = values;
        return this;
    }
    
    
    public EdgeAttributesBuilder setTeMetric(final Uint32 value) {
        this._teMetric = value;
        return this;
    }
    public EdgeAttributesBuilder setUnreservedBandwidth(final List<UnreservedBandwidth> values) {
        this._unreservedBandwidth = values;
        return this;
    }
    
    
    public EdgeAttributesBuilder setUtilizedBandwidth(final DecimalBandwidth value) {
        this._utilizedBandwidth = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public EdgeAttributesBuilder addAugmentation(Augmentation<EdgeAttributes> augmentation) {
        Class<? extends Augmentation<EdgeAttributes>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public EdgeAttributesBuilder removeAugmentation(Class<? extends Augmentation<EdgeAttributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link EdgeAttributes} instance.
     *
     * @return A new {@link EdgeAttributes} instance.
     */
    public EdgeAttributes build() {
        return new EdgeAttributesImpl(this);
    }

    private static final class EdgeAttributesImpl
        extends AbstractAugmentable<EdgeAttributes>
        implements EdgeAttributes {
    
        private final Uint32 _adjSid;
        private final Uint32 _adminGroup;
        private final DecimalBandwidth _availableBandwidth;
        private final Uint32 _backupAdjSid;
        private final Delay _delay;
        private final Delay _jitter;
        private final IpAddress _localAddress;
        private final Uint32 _localIdentifier;
        private final Loss _loss;
        private final DecimalBandwidth _maxLinkBandwidth;
        private final DecimalBandwidth _maxResvLinkBandwidth;
        private final Uint32 _metric;
        private final MinMaxDelay _minMaxDelay;
        private final IpAddress _remoteAddress;
        private final Uint32 _remoteIdentifier;
        private final DecimalBandwidth _residualBandwidth;
        private final Set<Uint32> _srlgs;
        private final Uint32 _teMetric;
        private final List<UnreservedBandwidth> _unreservedBandwidth;
        private final DecimalBandwidth _utilizedBandwidth;
    
        EdgeAttributesImpl(EdgeAttributesBuilder base) {
            super(base.augmentation);
            this._adjSid = base.getAdjSid();
            this._adminGroup = base.getAdminGroup();
            this._availableBandwidth = base.getAvailableBandwidth();
            this._backupAdjSid = base.getBackupAdjSid();
            this._delay = base.getDelay();
            this._jitter = base.getJitter();
            this._localAddress = base.getLocalAddress();
            this._localIdentifier = base.getLocalIdentifier();
            this._loss = base.getLoss();
            this._maxLinkBandwidth = base.getMaxLinkBandwidth();
            this._maxResvLinkBandwidth = base.getMaxResvLinkBandwidth();
            this._metric = base.getMetric();
            this._minMaxDelay = base.getMinMaxDelay();
            this._remoteAddress = base.getRemoteAddress();
            this._remoteIdentifier = base.getRemoteIdentifier();
            this._residualBandwidth = base.getResidualBandwidth();
            this._srlgs = base.getSrlgs();
            this._teMetric = base.getTeMetric();
            this._unreservedBandwidth = CodeHelpers.emptyToNull(base.getUnreservedBandwidth());
            this._utilizedBandwidth = base.getUtilizedBandwidth();
        }
    
        @Override
        public Uint32 getAdjSid() {
            return _adjSid;
        }
        
        @Override
        public Uint32 getAdminGroup() {
            return _adminGroup;
        }
        
        @Override
        public DecimalBandwidth getAvailableBandwidth() {
            return _availableBandwidth;
        }
        
        @Override
        public Uint32 getBackupAdjSid() {
            return _backupAdjSid;
        }
        
        @Override
        public Delay getDelay() {
            return _delay;
        }
        
        @Override
        public Delay getJitter() {
            return _jitter;
        }
        
        @Override
        public IpAddress getLocalAddress() {
            return _localAddress;
        }
        
        @Override
        public Uint32 getLocalIdentifier() {
            return _localIdentifier;
        }
        
        @Override
        public Loss getLoss() {
            return _loss;
        }
        
        @Override
        public DecimalBandwidth getMaxLinkBandwidth() {
            return _maxLinkBandwidth;
        }
        
        @Override
        public DecimalBandwidth getMaxResvLinkBandwidth() {
            return _maxResvLinkBandwidth;
        }
        
        @Override
        public Uint32 getMetric() {
            return _metric;
        }
        
        @Override
        public MinMaxDelay getMinMaxDelay() {
            return _minMaxDelay;
        }
        
        @Override
        public IpAddress getRemoteAddress() {
            return _remoteAddress;
        }
        
        @Override
        public Uint32 getRemoteIdentifier() {
            return _remoteIdentifier;
        }
        
        @Override
        public DecimalBandwidth getResidualBandwidth() {
            return _residualBandwidth;
        }
        
        @Override
        public Set<Uint32> getSrlgs() {
            return _srlgs;
        }
        
        @Override
        public Uint32 getTeMetric() {
            return _teMetric;
        }
        
        @Override
        public List<UnreservedBandwidth> getUnreservedBandwidth() {
            return _unreservedBandwidth;
        }
        
        @Override
        public DecimalBandwidth getUtilizedBandwidth() {
            return _utilizedBandwidth;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = EdgeAttributes.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return EdgeAttributes.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return EdgeAttributes.bindingToString(this);
        }
    }
}
