package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Delay;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Min/Max Unidirectional Delay
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * container min-max-delay {
 *   leaf min-delay {
 *     type delay;
 *   }
 *   leaf max-delay {
 *     type delay;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link MinMaxDelayBuilder}.
 * @see MinMaxDelayBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface MinMaxDelay
    extends
    ChildOf<EdgeAttributes>,
    Augmentable<MinMaxDelay>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("min-max-delay");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.MinMaxDelay> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.MinMaxDelay.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.@NonNull MinMaxDelay obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getMaxDelay());
        result = prime * result + Objects.hashCode(obj.getMinDelay());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.@NonNull MinMaxDelay thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.MinMaxDelay other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.MinMaxDelay.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getMaxDelay(), other.getMaxDelay())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMinDelay(), other.getMinDelay())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.@NonNull MinMaxDelay obj) {
        final var helper = MoreObjects.toStringHelper("MinMaxDelay");
        CodeHelpers.appendValue(helper, "maxDelay", obj.getMaxDelay());
        CodeHelpers.appendValue(helper, "minDelay", obj.getMinDelay());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return minDelay, or {@code null} if it is not present.
     *
     * @return {@code Delay} minDelay, or {@code null} if it is not present.
     *
     */
    Delay getMinDelay();
    
    /**
     * Return minDelay, guaranteed to be non-null.
     *
     * @return {@code Delay} minDelay, guaranteed to be non-null.
     * @throws NoSuchElementException if minDelay is not present
     *
     */
    default @NonNull Delay requireMinDelay() {
        return CodeHelpers.require(getMinDelay(), "mindelay");
    }
    
    /**
     * Return maxDelay, or {@code null} if it is not present.
     *
     * @return {@code Delay} maxDelay, or {@code null} if it is not present.
     *
     */
    Delay getMaxDelay();
    
    /**
     * Return maxDelay, guaranteed to be non-null.
     *
     * @return {@code Delay} maxDelay, guaranteed to be non-null.
     * @throws NoSuchElementException if maxDelay is not present
     *
     */
    default @NonNull Delay requireMaxDelay() {
        return CodeHelpers.require(getMaxDelay(), "maxdelay");
    }

}

