package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Delay;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link MinMaxDelay} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     MinMaxDelay createMinMaxDelay(int fooXyzzy, int barBaz) {
 *         return new MinMaxDelayBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of MinMaxDelay, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see MinMaxDelay
 *
 */
@Generated("mdsal-binding-generator")
public class MinMaxDelayBuilder {

    private Delay _maxDelay;
    private Delay _minDelay;


    Map<Class<? extends Augmentation<MinMaxDelay>>, Augmentation<MinMaxDelay>> augmentation = Collections.emptyMap();

    public MinMaxDelayBuilder() {
    }
    
    

    public MinMaxDelayBuilder(MinMaxDelay base) {
        Map<Class<? extends Augmentation<MinMaxDelay>>, Augmentation<MinMaxDelay>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._maxDelay = base.getMaxDelay();
        this._minDelay = base.getMinDelay();
    }


    public Delay getMaxDelay() {
        return _maxDelay;
    }
    
    public Delay getMinDelay() {
        return _minDelay;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<MinMaxDelay>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public MinMaxDelayBuilder setMaxDelay(final Delay value) {
        this._maxDelay = value;
        return this;
    }
    
    public MinMaxDelayBuilder setMinDelay(final Delay value) {
        this._minDelay = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MinMaxDelayBuilder addAugmentation(Augmentation<MinMaxDelay> augmentation) {
        Class<? extends Augmentation<MinMaxDelay>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MinMaxDelayBuilder removeAugmentation(Class<? extends Augmentation<MinMaxDelay>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link MinMaxDelay} instance.
     *
     * @return A new {@link MinMaxDelay} instance.
     */
    public MinMaxDelay build() {
        return new MinMaxDelayImpl(this);
    }

    private static final class MinMaxDelayImpl
        extends AbstractAugmentable<MinMaxDelay>
        implements MinMaxDelay {
    
        private final Delay _maxDelay;
        private final Delay _minDelay;
    
        MinMaxDelayImpl(MinMaxDelayBuilder base) {
            super(base.augmentation);
            this._maxDelay = base.getMaxDelay();
            this._minDelay = base.getMinDelay();
        }
    
        @Override
        public Delay getMaxDelay() {
            return _maxDelay;
        }
        
        @Override
        public Delay getMinDelay() {
            return _minDelay;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = MinMaxDelay.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return MinMaxDelay.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return MinMaxDelay.bindingToString(this);
        }
    }
}
