package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.DecimalBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Unreserved bandwidth for 0-7 class type
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * list unreserved-bandwidth {
 *   max-elements 8;
 *   ordered-by user;
 *   key class-type;
 *   leaf class-type {
 *     type uint8 {
 *       range 0..7;
 *     }
 *   }
 *   leaf bandwidth {
 *     type decimal-bandwidth;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link UnreservedBandwidthBuilder}.
 * @see UnreservedBandwidthBuilder
 * @see UnreservedBandwidthKey
 *
 */
@Generated("mdsal-binding-generator")
public interface UnreservedBandwidth
    extends
    ChildOf<EdgeAttributes>,
    Augmentable<UnreservedBandwidth>,
    Identifiable<UnreservedBandwidthKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("unreserved-bandwidth");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.UnreservedBandwidth> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.UnreservedBandwidth.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.@NonNull UnreservedBandwidth obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getBandwidth());
        result = prime * result + Objects.hashCode(obj.getClassType());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.@NonNull UnreservedBandwidth thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.UnreservedBandwidth other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.UnreservedBandwidth.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getBandwidth(), other.getBandwidth())) {
            return false;
        }
        if (!Objects.equals(thisObj.getClassType(), other.getClassType())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.@NonNull UnreservedBandwidth obj) {
        final var helper = MoreObjects.toStringHelper("UnreservedBandwidth");
        CodeHelpers.appendValue(helper, "bandwidth", obj.getBandwidth());
        CodeHelpers.appendValue(helper, "classType", obj.getClassType());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    UnreservedBandwidthKey key();
    
    /**
     * Return classType, or {@code null} if it is not present.
     *
     * @return {@code Uint8} classType, or {@code null} if it is not present.
     *
     */
    Uint8 getClassType();
    
    /**
     * Return classType, guaranteed to be non-null.
     *
     * @return {@code Uint8} classType, guaranteed to be non-null.
     * @throws NoSuchElementException if classType is not present
     *
     */
    default @NonNull Uint8 requireClassType() {
        return CodeHelpers.require(getClassType(), "classtype");
    }
    
    /**
     * Return bandwidth, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Unreserved bandwidth for this class type
     *     </code>
     * </pre>
     *
     * @return {@code DecimalBandwidth} bandwidth, or {@code null} if it is not present.
     *
     */
    DecimalBandwidth getBandwidth();
    
    /**
     * Return bandwidth, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Unreserved bandwidth for this class type
     *     </code>
     * </pre>
     *
     * @return {@code DecimalBandwidth} bandwidth, guaranteed to be non-null.
     * @throws NoSuchElementException if bandwidth is not present
     *
     */
    default @NonNull DecimalBandwidth requireBandwidth() {
        return CodeHelpers.require(getBandwidth(), "bandwidth");
    }

}

