package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * Class that builds {@link Prefix} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Prefix createPrefix(int fooXyzzy, int barBaz) {
 *         return new PrefixBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Prefix, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Prefix
 *
 */
@Generated("mdsal-binding-generator")
public class PrefixBuilder {

    private Boolean _nodeSid;
    private IpPrefix _prefix;
    private Uint32 _prefixSid;
    private Uint64 _vertexId;
    private PrefixKey key;


    Map<Class<? extends Augmentation<Prefix>>, Augmentation<Prefix>> augmentation = Collections.emptyMap();

    public PrefixBuilder() {
    }
    
    
    
    public PrefixBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix arg) {
        this._prefix = arg.getPrefix();
        this._prefixSid = arg.getPrefixSid();
        this._nodeSid = arg.getNodeSid();
        this._vertexId = arg.getVertexId();
    }
    

    public PrefixBuilder(Prefix base) {
        Map<Class<? extends Augmentation<Prefix>>, Augmentation<Prefix>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._prefix = base.getPrefix();
        this._nodeSid = base.getNodeSid();
        this._prefixSid = base.getPrefixSid();
        this._vertexId = base.getVertexId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix) {
            this._prefix = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix)arg).getPrefix();
            this._prefixSid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix)arg).getPrefixSid();
            this._nodeSid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix)arg).getNodeSid();
            this._vertexId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix)arg).getVertexId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix]");
    }

    public PrefixKey key() {
        return key;
    }
    
    public Boolean getNodeSid() {
        return _nodeSid;
    }
    
    public IpPrefix getPrefix() {
        return _prefix;
    }
    
    public Uint32 getPrefixSid() {
        return _prefixSid;
    }
    
    public Uint64 getVertexId() {
        return _vertexId;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Prefix>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PrefixBuilder withKey(final PrefixKey key) {
        this.key = key;
        return this;
    }
    
    public PrefixBuilder setNodeSid(final Boolean value) {
        this._nodeSid = value;
        return this;
    }
    
    public PrefixBuilder setPrefix(final IpPrefix value) {
        this._prefix = value;
        return this;
    }
    
    public PrefixBuilder setPrefixSid(final Uint32 value) {
        this._prefixSid = value;
        return this;
    }
    
    public PrefixBuilder setVertexId(final Uint64 value) {
        this._vertexId = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PrefixBuilder addAugmentation(Augmentation<Prefix> augmentation) {
        Class<? extends Augmentation<Prefix>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PrefixBuilder removeAugmentation(Class<? extends Augmentation<Prefix>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Prefix} instance.
     *
     * @return A new {@link Prefix} instance.
     */
    public Prefix build() {
        return new PrefixImpl(this);
    }

    private static final class PrefixImpl
        extends AbstractAugmentable<Prefix>
        implements Prefix {
    
        private final Boolean _nodeSid;
        private final IpPrefix _prefix;
        private final Uint32 _prefixSid;
        private final Uint64 _vertexId;
        private final PrefixKey key;
    
        PrefixImpl(PrefixBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new PrefixKey(base.getPrefix());
            }
            this._prefix = key.getPrefix();
            this._nodeSid = base.getNodeSid();
            this._prefixSid = base.getPrefixSid();
            this._vertexId = base.getVertexId();
        }
    
        @Override
        public PrefixKey key() {
            return key;
        }
        
        @Override
        public Boolean getNodeSid() {
            return _nodeSid;
        }
        
        @Override
        public IpPrefix getPrefix() {
            return _prefix;
        }
        
        @Override
        public Uint32 getPrefixSid() {
            return _prefixSid;
        }
        
        @Override
        public Uint64 getVertexId() {
            return _vertexId;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Prefix.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Prefix.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Prefix.bindingToString(this);
        }
    }
}
