/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.vertex.Srgb;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;

public interface Vertex
extends DataObject {
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vertex");

    public Class<? extends Vertex> implementedInterface();

    public Uint64 getVertexId();

    default public @NonNull Uint64 requireVertexId() {
        return (Uint64)CodeHelpers.require((Object)this.getVertexId(), (String)"vertexid");
    }

    public String getName();

    default public @NonNull String requireName() {
        return (String)CodeHelpers.require((Object)this.getName(), (String)"name");
    }

    public IpAddress getRouterId();

    default public @NonNull IpAddress requireRouterId() {
        return (IpAddress)CodeHelpers.require((Object)this.getRouterId(), (String)"routerid");
    }

    public VertexType getVertexType();

    default public @NonNull VertexType requireVertexType() {
        return (VertexType)((Object)CodeHelpers.require((Object)((Object)this.getVertexType()), (String)"vertextype"));
    }

    public Srgb getSrgb();

    public Uint32 getAsn();

    default public @NonNull Uint32 requireAsn() {
        return (Uint32)CodeHelpers.require((Object)this.getAsn(), (String)"asn");
    }

    public static enum VertexType implements Enumeration
    {
        Standard(0, "standard"),
        Abr(1, "abr"),
        AsbrIn(2, "asbr-in"),
        AsbrOut(3, "asbr-out"),
        Pseudo(4, "pseudo");

        private static final Map<String, VertexType> NAME_MAP;
        private static final Map<Integer, VertexType> VALUE_MAP;
        private final String name;
        private final int value;

        private VertexType(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static Optional<VertexType> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }

        public static VertexType forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }

        static {
            ImmutableMap.Builder nb = ImmutableMap.builder();
            ImmutableMap.Builder vb = ImmutableMap.builder();
            for (VertexType enumItem : VertexType.values()) {
                vb.put((Object)enumItem.value, (Object)enumItem);
                nb.put((Object)enumItem.name, (Object)enumItem);
            }
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    }
}

