package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Range;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.Override;
import java.lang.String;
import java.lang.reflect.Array;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Decimal64;

@Generated("mdsal-binding-generator")
public class DecimalBandwidth
 implements ScalarTypeObject<Decimal64>, Serializable {
    private static final long serialVersionUID = 8069688163137208190L;
    public static final String _UNITS = "bytes/second";
    private final Decimal64 _value;

    private static final Range<Decimal64>[] CHECK_VALUERANGE_RANGES;
    static {
        @SuppressWarnings("unchecked")
        final Range<Decimal64>[] a = (Range<Decimal64>[]) Array.newInstance(Range.class, 1);
        a[0] = Range.closed(Decimal64.of(2, -9223372036854775808L), Decimal64.of(2, 9223372036854775807L));
        CHECK_VALUERANGE_RANGES = a;
    }
    private static void check_valueRange(final org.opendaylight.yangtools.yang.common.Decimal64 value) {
        for (Range<Decimal64> r : CHECK_VALUERANGE_RANGES) {
            if (r.contains(value)) {
                return;
            }
        }
        CodeHelpers.throwInvalidRange(CHECK_VALUERANGE_RANGES, value);
    }

    @ConstructorParameters("value")
    @ConstructorProperties("value")
    public DecimalBandwidth(Decimal64 _value) {
        if (_value != null) {
            check_valueRange(_value);
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public DecimalBandwidth(DecimalBandwidth source) {
        this._value = source._value;
    }

    public static DecimalBandwidth getDefaultInstance(final String defaultValue) {
        return new DecimalBandwidth(Decimal64.valueOf(defaultValue));
    }

    @Override
    public Decimal64 getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DecimalBandwidth)) {
            return false;
        }
        final DecimalBandwidth other = (DecimalBandwidth) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(DecimalBandwidth.class);
        CodeHelpers.appendValue(helper, "_value", _value);
        CodeHelpers.appendValue(helper, "_UNITS", _UNITS);
        return helper.toString();
    }
}

