package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.GraphTopology;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Edge;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.EdgeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.PrefixKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Vertex;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.VertexKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Graph representation of the Network Topology
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * list graph {
 *   key name;
 *   leaf name {
 *     type string;
 *   }
 *   leaf domain-scope {
 *     type enumeration {
 *       enum intra-domain {
 *         value 1;
 *       }
 *       enum inter-domain {
 *         value 2;
 *       }
 *     }
 *     default intra-domain;
 *   }
 *   leaf asn {
 *     type uint32;
 *   }
 *   list vertex {
 *     key vertex-id;
 *     uses vertex;
 *   }
 *   list edge {
 *     key edge-id;
 *     uses edge;
 *   }
 *   list prefix {
 *     key prefix;
 *     uses prefix;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link GraphBuilder}.
 * @see GraphBuilder
 * @see GraphKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Graph
    extends
    ChildOf<GraphTopology>,
    Augmentable<Graph>,
    Identifiable<GraphKey>
{


    @Generated("mdsal-binding-generator")
    public enum DomainScope implements Enumeration {
        IntraDomain(1, "intra-domain"),
        
        InterDomain(2, "inter-domain")
        ;
    
        private static final Map<String, DomainScope> NAME_MAP;
        private static final Map<Integer, DomainScope> VALUE_MAP;
    
        static {
            final Builder<String, DomainScope> nb = ImmutableMap.builder();
            final Builder<Integer, DomainScope> vb = ImmutableMap.builder();
            for (DomainScope enumItem : DomainScope.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private DomainScope(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding DomainScope item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<DomainScope> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding DomainScope item, or null if no such item exists
         */
        public static DomainScope forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("graph");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.@NonNull Graph obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAsn());
        result = prime * result + Objects.hashCode(obj.getDomainScope());
        result = prime * result + Objects.hashCode(obj.getEdge());
        result = prime * result + Objects.hashCode(obj.getName());
        result = prime * result + Objects.hashCode(obj.getPrefix());
        result = prime * result + Objects.hashCode(obj.getVertex());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.@NonNull Graph thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAsn(), other.getAsn())) {
            return false;
        }
        if (!Objects.equals(thisObj.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDomainScope(), other.getDomainScope())) {
            return false;
        }
        if (!Objects.equals(thisObj.getEdge(), other.getEdge())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPrefix(), other.getPrefix())) {
            return false;
        }
        if (!Objects.equals(thisObj.getVertex(), other.getVertex())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.@NonNull Graph obj) {
        final var helper = MoreObjects.toStringHelper("Graph");
        CodeHelpers.appendValue(helper, "asn", obj.getAsn());
        CodeHelpers.appendValue(helper, "domainScope", obj.getDomainScope());
        CodeHelpers.appendValue(helper, "edge", obj.getEdge());
        CodeHelpers.appendValue(helper, "name", obj.getName());
        CodeHelpers.appendValue(helper, "prefix", obj.getPrefix());
        CodeHelpers.appendValue(helper, "vertex", obj.getVertex());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    GraphKey key();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return domainScope, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Network domain scope: intra or inter domain
     *     </code>
     * </pre>
     *
     * @return {@code DomainScope} domainScope, or {@code null} if it is not present.
     *
     */
    DomainScope getDomainScope();
    
    /**
     * Return domainScope, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Network domain scope: intra or inter domain
     *     </code>
     * </pre>
     *
     * @return {@code DomainScope} domainScope, guaranteed to be non-null.
     * @throws NoSuchElementException if domainScope is not present
     *
     */
    default @NonNull DomainScope requireDomainScope() {
        return CodeHelpers.require(getDomainScope(), "domainscope");
    }
    
    /**
     * Return asn, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         AS Number
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} asn, or {@code null} if it is not present.
     *
     */
    Uint32 getAsn();
    
    /**
     * Return asn, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         AS Number
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} asn, guaranteed to be non-null.
     * @throws NoSuchElementException if asn is not present
     *
     */
    default @NonNull Uint32 requireAsn() {
        return CodeHelpers.require(getAsn(), "asn");
    }
    
    /**
     * Return vertex, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The list of Vertices defined for the Graph.
     *     </code>
     * </pre>
     *
     * @return {@code Map<VertexKey, Vertex>} vertex, or {@code null} if it is not present.
     *
     */
    @Nullable Map<VertexKey, Vertex> getVertex();
    
    /**
     * Return vertex, or an empty list if it is not present.
     *
     * @return {@code Map<VertexKey, Vertex>} vertex, or an empty list if it is not present.
     *
     */
    default @NonNull Map<VertexKey, Vertex> nonnullVertex() {
        return CodeHelpers.nonnull(getVertex());
    }
    
    /**
     * Return edge, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The list of Edges defined for the Graph.
     *     </code>
     * </pre>
     *
     * @return {@code Map<EdgeKey, Edge>} edge, or {@code null} if it is not present.
     *
     */
    @Nullable Map<EdgeKey, Edge> getEdge();
    
    /**
     * Return edge, or an empty list if it is not present.
     *
     * @return {@code Map<EdgeKey, Edge>} edge, or an empty list if it is not present.
     *
     */
    default @NonNull Map<EdgeKey, Edge> nonnullEdge() {
        return CodeHelpers.nonnull(getEdge());
    }
    
    /**
     * Return prefix, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The list of prefixes for the Graph.
     *     </code>
     * </pre>
     *
     * @return {@code Map<PrefixKey, Prefix>} prefix, or {@code null} if it is not present.
     *
     */
    @Nullable Map<PrefixKey, Prefix> getPrefix();
    
    /**
     * Return prefix, or an empty list if it is not present.
     *
     * @return {@code Map<PrefixKey, Prefix>} prefix, or an empty list if it is not present.
     *
     */
    default @NonNull Map<PrefixKey, Prefix> nonnullPrefix() {
        return CodeHelpers.nonnull(getPrefix());
    }

}

