package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Edge;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.EdgeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.PrefixKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Vertex;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.VertexKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link Graph} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Graph createGraph(int fooXyzzy, int barBaz) {
 *         return new GraphBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Graph, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Graph
 *
 */
@Generated("mdsal-binding-generator")
public class GraphBuilder {

    private Uint32 _asn;
    private Graph.DomainScope _domainScope;
    private Map<EdgeKey, Edge> _edge;
    private String _name;
    private Map<PrefixKey, Prefix> _prefix;
    private Map<VertexKey, Vertex> _vertex;
    private GraphKey key;


    Map<Class<? extends Augmentation<Graph>>, Augmentation<Graph>> augmentation = Collections.emptyMap();

    public GraphBuilder() {
    }
    
    
    

    public GraphBuilder(Graph base) {
        Map<Class<? extends Augmentation<Graph>>, Augmentation<Graph>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._asn = base.getAsn();
        this._domainScope = base.getDomainScope();
        this._edge = base.getEdge();
        this._prefix = base.getPrefix();
        this._vertex = base.getVertex();
    }


    public GraphKey key() {
        return key;
    }
    
    public Uint32 getAsn() {
        return _asn;
    }
    
    public Graph.DomainScope getDomainScope() {
        return _domainScope;
    }
    
    public Map<EdgeKey, Edge> getEdge() {
        return _edge;
    }
    
    public String getName() {
        return _name;
    }
    
    public Map<PrefixKey, Prefix> getPrefix() {
        return _prefix;
    }
    
    public Map<VertexKey, Vertex> getVertex() {
        return _vertex;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Graph>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public GraphBuilder withKey(final GraphKey key) {
        this.key = key;
        return this;
    }
    
    public GraphBuilder setAsn(final Uint32 value) {
        this._asn = value;
        return this;
    }
    
    public GraphBuilder setDomainScope(final Graph.DomainScope value) {
        this._domainScope = value;
        return this;
    }
    public GraphBuilder setEdge(final Map<EdgeKey, Edge> values) {
        this._edge = values;
        return this;
    }
    
    public GraphBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    public GraphBuilder setPrefix(final Map<PrefixKey, Prefix> values) {
        this._prefix = values;
        return this;
    }
    public GraphBuilder setVertex(final Map<VertexKey, Vertex> values) {
        this._vertex = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public GraphBuilder addAugmentation(Augmentation<Graph> augmentation) {
        Class<? extends Augmentation<Graph>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public GraphBuilder removeAugmentation(Class<? extends Augmentation<Graph>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Graph} instance.
     *
     * @return A new {@link Graph} instance.
     */
    public Graph build() {
        return new GraphImpl(this);
    }

    private static final class GraphImpl
        extends AbstractAugmentable<Graph>
        implements Graph {
    
        private final Uint32 _asn;
        private final Graph.DomainScope _domainScope;
        private final Map<EdgeKey, Edge> _edge;
        private final String _name;
        private final Map<PrefixKey, Prefix> _prefix;
        private final Map<VertexKey, Vertex> _vertex;
        private final GraphKey key;
    
        GraphImpl(GraphBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new GraphKey(base.getName());
            }
            this._name = key.getName();
            this._asn = base.getAsn();
            this._domainScope = base.getDomainScope();
            this._edge = CodeHelpers.emptyToNull(base.getEdge());
            this._prefix = CodeHelpers.emptyToNull(base.getPrefix());
            this._vertex = CodeHelpers.emptyToNull(base.getVertex());
        }
    
        @Override
        public GraphKey key() {
            return key;
        }
        
        @Override
        public Uint32 getAsn() {
            return _asn;
        }
        
        @Override
        public Graph.DomainScope getDomainScope() {
            return _domainScope;
        }
        
        @Override
        public Map<EdgeKey, Edge> getEdge() {
            return _edge;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public Map<PrefixKey, Prefix> getPrefix() {
            return _prefix;
        }
        
        @Override
        public Map<VertexKey, Vertex> getVertex() {
            return _vertex;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Graph.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Graph.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Graph.bindingToString(this);
        }
    }
}
