package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.vertex;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link Srgb} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Srgb createSrgb(int fooXyzzy, int barBaz) {
 *         return new SrgbBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Srgb, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Srgb
 *
 */
@Generated("mdsal-binding-generator")
public class SrgbBuilder {

    private Uint32 _lowerBound;
    private Uint32 _rangeSize;


    Map<Class<? extends Augmentation<Srgb>>, Augmentation<Srgb>> augmentation = Collections.emptyMap();

    public SrgbBuilder() {
    }
    
    
    
    public SrgbBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Srgb arg) {
        this._lowerBound = arg.getLowerBound();
        this._rangeSize = arg.getRangeSize();
    }

    public SrgbBuilder(Srgb base) {
        Map<Class<? extends Augmentation<Srgb>>, Augmentation<Srgb>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._lowerBound = base.getLowerBound();
        this._rangeSize = base.getRangeSize();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Srgb</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Srgb) {
            this._lowerBound = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Srgb)arg).getLowerBound();
            this._rangeSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Srgb)arg).getRangeSize();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Srgb]");
    }

    public Uint32 getLowerBound() {
        return _lowerBound;
    }
    
    public Uint32 getRangeSize() {
        return _rangeSize;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Srgb>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public SrgbBuilder setLowerBound(final Uint32 value) {
        this._lowerBound = value;
        return this;
    }
    
    public SrgbBuilder setRangeSize(final Uint32 value) {
        this._rangeSize = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SrgbBuilder addAugmentation(Augmentation<Srgb> augmentation) {
        Class<? extends Augmentation<Srgb>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SrgbBuilder removeAugmentation(Class<? extends Augmentation<Srgb>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Srgb} instance.
     *
     * @return A new {@link Srgb} instance.
     */
    public Srgb build() {
        return new SrgbImpl(this);
    }

    private static final class SrgbImpl
        extends AbstractAugmentable<Srgb>
        implements Srgb {
    
        private final Uint32 _lowerBound;
        private final Uint32 _rangeSize;
    
        SrgbImpl(SrgbBuilder base) {
            super(base.augmentation);
            this._lowerBound = base.getLowerBound();
            this._rangeSize = base.getRangeSize();
        }
    
        @Override
        public Uint32 getLowerBound() {
            return _lowerBound;
        }
        
        @Override
        public Uint32 getRangeSize() {
            return _rangeSize;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Srgb.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Srgb.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Srgb.bindingToString(this);
        }
    }
}
