/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.GraphTopology;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.GraphKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.Edge;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.EdgeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.PrefixKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.Vertex;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.VertexKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

public interface Graph
extends ChildOf<GraphTopology>,
Augmentable<Graph>,
Identifiable<GraphKey> {
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("graph");

    default public Class<Graph> implementedInterface() {
        return Graph.class;
    }

    public static int bindingHashCode(@NonNull Graph obj) {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(obj.getAsn());
        result = 31 * result + Objects.hashCode((Object)obj.getDomainScope());
        result = 31 * result + Objects.hashCode(obj.getEdge());
        result = 31 * result + Objects.hashCode(obj.getName());
        result = 31 * result + Objects.hashCode(obj.getPrefix());
        result = 31 * result + Objects.hashCode(obj.getVertex());
        for (Augmentation augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }

    public static boolean bindingEquals(@NonNull Graph thisObj, Object obj) {
        if (thisObj == obj) {
            return true;
        }
        Graph other = (Graph)CodeHelpers.checkCast(Graph.class, (Object)obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAsn(), other.getAsn())) {
            return false;
        }
        if (!Objects.equals(thisObj.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals((Object)thisObj.getDomainScope(), (Object)other.getDomainScope())) {
            return false;
        }
        if (!Objects.equals(thisObj.getEdge(), other.getEdge())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPrefix(), other.getPrefix())) {
            return false;
        }
        if (!Objects.equals(thisObj.getVertex(), other.getVertex())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }

    public static String bindingToString(@NonNull Graph obj) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Graph");
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"asn", (Object)obj.getAsn());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"domainScope", (Object)((Object)obj.getDomainScope()));
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"edge", obj.getEdge());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"name", (Object)obj.getName());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"prefix", obj.getPrefix());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"vertex", obj.getVertex());
        CodeHelpers.appendAugmentations((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Augmentable)obj);
        return helper.toString();
    }

    public GraphKey key();

    public String getName();

    default public @NonNull String requireName() {
        return (String)CodeHelpers.require((Object)this.getName(), (String)"name");
    }

    public DomainScope getDomainScope();

    default public @NonNull DomainScope requireDomainScope() {
        return (DomainScope)((Object)CodeHelpers.require((Object)((Object)this.getDomainScope()), (String)"domainscope"));
    }

    public Uint32 getAsn();

    default public @NonNull Uint32 requireAsn() {
        return (Uint32)CodeHelpers.require((Object)this.getAsn(), (String)"asn");
    }

    public @Nullable Map<VertexKey, Vertex> getVertex();

    default public @NonNull Map<VertexKey, Vertex> nonnullVertex() {
        return CodeHelpers.nonnull(this.getVertex());
    }

    public @Nullable Map<EdgeKey, Edge> getEdge();

    default public @NonNull Map<EdgeKey, Edge> nonnullEdge() {
        return CodeHelpers.nonnull(this.getEdge());
    }

    public @Nullable Map<PrefixKey, Prefix> getPrefix();

    default public @NonNull Map<PrefixKey, Prefix> nonnullPrefix() {
        return CodeHelpers.nonnull(this.getPrefix());
    }

    public static enum DomainScope implements Enumeration
    {
        IntraDomain(1, "intra-domain"),
        InterDomain(2, "inter-domain");

        private final @NonNull String name;
        private final int value;

        private DomainScope(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static @Nullable DomainScope forName(String name) {
            return switch (name) {
                case "intra-domain" -> IntraDomain;
                case "inter-domain" -> InterDomain;
                default -> null;
            };
        }

        public static @Nullable DomainScope forValue(int intValue) {
            return switch (intValue) {
                case 1 -> IntraDomain;
                case 2 -> InterDomain;
                default -> null;
            };
        }

        public static @NonNull DomainScope ofName(String name) {
            return (DomainScope)CodeHelpers.checkEnum((Enumeration)DomainScope.forName(name), (String)name);
        }

        public static @NonNull DomainScope ofValue(int intValue) {
            return (DomainScope)CodeHelpers.checkEnum((Enumeration)DomainScope.forValue(intValue), (int)intValue);
        }
    }
}

