package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.Graph;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.GraphKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * container graph-topology {
 *   list graph {
 *     key name;
 *     leaf name {
 *       type string;
 *     }
 *     leaf domain-scope {
 *       type enumeration {
 *         enum intra-domain {
 *           value 1;
 *         }
 *         enum inter-domain {
 *           value 2;
 *         }
 *       }
 *       default intra-domain;
 *     }
 *     leaf asn {
 *       type uint32;
 *     }
 *     list vertex {
 *       key vertex-id;
 *       uses vertex;
 *     }
 *     list edge {
 *       key edge-id;
 *       uses edge;
 *     }
 *     list prefix {
 *       key prefix;
 *       uses prefix;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link GraphTopologyBuilder}.
 * @see GraphTopologyBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface GraphTopology
    extends
    ChildOf<GraphData>,
    Augmentable<GraphTopology>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("graph-topology");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.GraphTopology> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.GraphTopology.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.@NonNull GraphTopology obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getGraph());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.@NonNull GraphTopology thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.GraphTopology.class, obj);
        return other != null
            && Objects.equals(thisObj.getGraph(), other.getGraph())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.@NonNull GraphTopology obj) {
        final var helper = MoreObjects.toStringHelper("GraphTopology");
        CodeHelpers.appendValue(helper, "graph", obj.getGraph());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return graph, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Graph representation of the Network Topology
     *     </code>
     * </pre>
     *
     * @return {@code Map<GraphKey, Graph>} graph, or {@code null} if it is not present.
     *
     */
    @Nullable Map<GraphKey, Graph> getGraph();
    
    /**
     * Return graph, or an empty list if it is not present.
     *
     * @return {@code Map<GraphKey, Graph>} graph, or an empty list if it is not present.
     *
     */
    default @NonNull Map<GraphKey, Graph> nonnullGraph() {
        return CodeHelpers.nonnull(getGraph());
    }

}

