package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.vertex.Srgb;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * Vertex (node) representation for the network topology
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * grouping vertex {
 *   leaf vertex-id {
 *     type uint64;
 *   }
 *   leaf name {
 *     type string;
 *   }
 *   leaf router-id {
 *     type inet:ipv4-address;
 *   }
 *   leaf router-id6 {
 *     type inet:ipv6-address;
 *   }
 *   leaf vertex-type {
 *     type enumeration {
 *       enum standard {
 *         value 0;
 *       }
 *       enum abr {
 *         value 1;
 *       }
 *       enum asbr-in {
 *         value 2;
 *       }
 *       enum asbr-out {
 *         value 3;
 *       }
 *       enum pseudo {
 *         value 4;
 *       }
 *     }
 *     default standard;
 *   }
 *   container srgb {
 *     uses srgb;
 *   }
 *   leaf asn {
 *     type uint32;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface Vertex
    extends
    DataObject
{


    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>graph</b>
     * <pre>
     * leaf vertex-type {
     *   type enumeration {
     *     enum standard {
     *       value 0;
     *     }
     *     enum abr {
     *       value 1;
     *     }
     *     enum asbr-in {
     *       value 2;
     *     }
     *     enum asbr-out {
     *       value 3;
     *     }
     *     enum pseudo {
     *       value 4;
     *     }
     *   }
     *   default standard;
     * }
     * </pre>
     *
     */
    @Generated("mdsal-binding-generator")
    public enum VertexType implements EnumTypeObject {
        Standard(0, "standard"),
        
        Abr(1, "abr"),
        
        AsbrIn(2, "asbr-in"),
        
        AsbrOut(3, "asbr-out"),
        
        Pseudo(4, "pseudo")
        ;
    
        private final @NonNull String name;
        private final int value;
    
        private VertexType(int value, @NonNull String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public @NonNull String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding VertexType item, or {@code null} if no such item exists
         * @throws NullPointerException if {@code name} is null
         */
        public static @Nullable VertexType forName(String name) {
            return switch (name) {
                case "standard" -> Standard;
                case "abr" -> Abr;
                case "asbr-in" -> AsbrIn;
                case "asbr-out" -> AsbrOut;
                case "pseudo" -> Pseudo;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding VertexType item, or {@code null} if no such item exists
         */
        public static @Nullable VertexType forValue(int intValue) {
            return switch (intValue) {
                case 0 -> Standard;
                case 1 -> Abr;
                case 2 -> AsbrIn;
                case 3 -> AsbrOut;
                case 4 -> Pseudo;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding VertexType item
         * @throws NullPointerException if {@code name} is null
         * @throws IllegalArgumentException if {@code name} does not match any item
         */
        public static @NonNull VertexType ofName(String name) {
            return CodeHelpers.checkEnum(forName(name), name);
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding VertexType item
         * @throws IllegalArgumentException if {@code intValue} does not match any item
         */
        public static @NonNull VertexType ofValue(int intValue) {
            return CodeHelpers.checkEnum(forValue(intValue), intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vertex");

    @Override
    Class<? extends Vertex> implementedInterface();
    
    /**
     * Return vertexId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Identifier of the Vertex
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} vertexId, or {@code null} if it is not present.
     *
     */
    Uint64 getVertexId();
    
    /**
     * Return vertexId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Identifier of the Vertex
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} vertexId, guaranteed to be non-null.
     * @throws NoSuchElementException if vertexId is not present
     *
     */
    default @NonNull Uint64 requireVertexId() {
        return CodeHelpers.require(getVertexId(), "vertexid");
    }
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Name of the Vertex when known
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Name of the Vertex when known
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return routerId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Global unique IPv4 Trafic Engineering Router ID
     *     </code>
     * </pre>
     *
     * @return {@code Ipv4Address} routerId, or {@code null} if it is not present.
     *
     */
    Ipv4Address getRouterId();
    
    /**
     * Return routerId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Global unique IPv4 Trafic Engineering Router ID
     *     </code>
     * </pre>
     *
     * @return {@code Ipv4Address} routerId, guaranteed to be non-null.
     * @throws NoSuchElementException if routerId is not present
     *
     */
    default @NonNull Ipv4Address requireRouterId() {
        return CodeHelpers.require(getRouterId(), "routerid");
    }
    
    /**
     * Return routerId6, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Global unique IPv6 Trafic Engineering Router ID
     *     </code>
     * </pre>
     *
     * @return {@code Ipv6Address} routerId6, or {@code null} if it is not present.
     *
     */
    Ipv6Address getRouterId6();
    
    /**
     * Return routerId6, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Global unique IPv6 Trafic Engineering Router ID
     *     </code>
     * </pre>
     *
     * @return {@code Ipv6Address} routerId6, guaranteed to be non-null.
     * @throws NoSuchElementException if routerId6 is not present
     *
     */
    default @NonNull Ipv6Address requireRouterId6() {
        return CodeHelpers.require(getRouterId6(), "routerid6");
    }
    
    /**
     * Return vertexType, or {@code null} if it is not present.
     *
     * @return {@code VertexType} vertexType, or {@code null} if it is not present.
     *
     */
    VertexType getVertexType();
    
    /**
     * Return vertexType, guaranteed to be non-null.
     *
     * @return {@code VertexType} vertexType, guaranteed to be non-null.
     * @throws NoSuchElementException if vertexType is not present
     *
     */
    default @NonNull VertexType requireVertexType() {
        return CodeHelpers.require(getVertexType(), "vertextype");
    }
    
    /**
     * Return srgb, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Segment Routing Global Block
     *     </code>
     * </pre>
     *
     * @return {@code Srgb} srgb, or {@code null} if it is not present.
     *
     */
    Srgb getSrgb();
    
    /**
     * Return srgb, or an empty instance if it is not present.
     *
     * @return {@code Srgb} srgb, or an empty instance if it is not present.
     *
     */
    @NonNull Srgb nonnullSrgb();
    
    /**
     * Return asn, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         AS Number
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} asn, or {@code null} if it is not present.
     *
     */
    Uint32 getAsn();
    
    /**
     * Return asn, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         AS Number
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} asn, guaranteed to be non-null.
     * @throws NoSuchElementException if asn is not present
     *
     */
    default @NonNull Uint32 requireAsn() {
        return CodeHelpers.require(getAsn(), "asn");
    }

}

