package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.attributes;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.DecimalBandwidth;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link UnreservedBandwidth} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     UnreservedBandwidth createUnreservedBandwidth(int fooXyzzy, int barBaz) {
 *         return new UnreservedBandwidthBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of UnreservedBandwidth, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see UnreservedBandwidth
 *
 */
@Generated("mdsal-binding-generator")
public class UnreservedBandwidthBuilder {

    private DecimalBandwidth _bandwidth;
    private Uint8 _classType;
    private UnreservedBandwidthKey key;


    Map<Class<? extends Augmentation<UnreservedBandwidth>>, Augmentation<UnreservedBandwidth>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public UnreservedBandwidthBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link UnreservedBandwidth}.
     *
     * @param base UnreservedBandwidth from which the builder should be initialized
     */
    public UnreservedBandwidthBuilder(UnreservedBandwidth base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._classType = base.getClassType();
        this._bandwidth = base.getBandwidth();
    }



    /**
     * Return current value associated with the property corresponding to {@link UnreservedBandwidth#key()}.
     *
     * @return current value
     */
    public UnreservedBandwidthKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link UnreservedBandwidth#getBandwidth()}.
     *
     * @return current value
     */
    public DecimalBandwidth getBandwidth() {
        return _bandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link UnreservedBandwidth#getClassType()}.
     *
     * @return current value
     */
    public Uint8 getClassType() {
        return _classType;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<UnreservedBandwidth>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link UnreservedBandwidth#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public UnreservedBandwidthBuilder withKey(final UnreservedBandwidthKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link UnreservedBandwidth#getBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UnreservedBandwidthBuilder setBandwidth(final DecimalBandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
    private static void checkClassTypeRange(final short value) {
        if (value <= (short)7) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..7]]", value);
    }
    
    /**
     * Set the property corresponding to {@link UnreservedBandwidth#getClassType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UnreservedBandwidthBuilder setClassType(final Uint8 value) {
        if (value != null) {
            checkClassTypeRange(value.shortValue());
            
        }
        this._classType = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public UnreservedBandwidthBuilder addAugmentation(Augmentation<UnreservedBandwidth> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public UnreservedBandwidthBuilder removeAugmentation(Class<? extends Augmentation<UnreservedBandwidth>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link UnreservedBandwidth} instance.
     *
     * @return A new {@link UnreservedBandwidth} instance.
     */
    public @NonNull UnreservedBandwidth build() {
        return new UnreservedBandwidthImpl(this);
    }

    private static final class UnreservedBandwidthImpl
        extends AbstractAugmentable<UnreservedBandwidth>
        implements UnreservedBandwidth {
    
        private final DecimalBandwidth _bandwidth;
        private final Uint8 _classType;
        private final UnreservedBandwidthKey key;
    
        UnreservedBandwidthImpl(UnreservedBandwidthBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new UnreservedBandwidthKey(base.getClassType());
            }
            this._classType = key.getClassType();
            this._bandwidth = base.getBandwidth();
        }
    
        @Override
        public UnreservedBandwidthKey key() {
            return key;
        }
        
        @Override
        public DecimalBandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public Uint8 getClassType() {
            return _classType;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = UnreservedBandwidth.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return UnreservedBandwidth.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return UnreservedBandwidth.bindingToString(this);
        }
    }
}
