package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.EdgeAttributes;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * Class that builds {@link Edge} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Edge createEdge(int fooXyzzy, int barBaz) {
 *         return new EdgeBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Edge, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Edge
 *
 */
@Generated("mdsal-binding-generator")
public class EdgeBuilder {

    private EdgeAttributes _edgeAttributes;
    private Uint64 _edgeId;
    private Uint64 _localVertexId;
    private String _name;
    private Uint64 _remoteVertexId;
    private EdgeKey key;


    Map<Class<? extends Augmentation<Edge>>, Augmentation<Edge>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public EdgeBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Edge}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Edge from which the builder should be initialized
     */
    public EdgeBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Edge arg) {
        this._edgeId = arg.getEdgeId();
        this._localVertexId = arg.getLocalVertexId();
        this._remoteVertexId = arg.getRemoteVertexId();
        this._name = arg.getName();
        this._edgeAttributes = arg.getEdgeAttributes();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Edge}.
     *
     * @param base Edge from which the builder should be initialized
     */
    public EdgeBuilder(Edge base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._edgeId = base.getEdgeId();
        this._edgeAttributes = base.getEdgeAttributes();
        this._localVertexId = base.getLocalVertexId();
        this._name = base.getName();
        this._remoteVertexId = base.getRemoteVertexId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Edge}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Edge castArg) {
            this._edgeId = castArg.getEdgeId();
            this._localVertexId = castArg.getLocalVertexId();
            this._remoteVertexId = castArg.getRemoteVertexId();
            this._name = castArg.getName();
            this._edgeAttributes = castArg.getEdgeAttributes();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Edge]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Edge#key()}.
     *
     * @return current value
     */
    public EdgeKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Edge#getEdgeAttributes()}.
     *
     * @return current value
     */
    public EdgeAttributes getEdgeAttributes() {
        return _edgeAttributes;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Edge#getEdgeId()}.
     *
     * @return current value
     */
    public Uint64 getEdgeId() {
        return _edgeId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Edge#getLocalVertexId()}.
     *
     * @return current value
     */
    public Uint64 getLocalVertexId() {
        return _localVertexId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Edge#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Edge#getRemoteVertexId()}.
     *
     * @return current value
     */
    public Uint64 getRemoteVertexId() {
        return _remoteVertexId;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Edge>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Edge#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public EdgeBuilder withKey(final EdgeKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Edge#getEdgeAttributes()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeBuilder setEdgeAttributes(final EdgeAttributes value) {
        this._edgeAttributes = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Edge#getEdgeId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeBuilder setEdgeId(final Uint64 value) {
        this._edgeId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Edge#getLocalVertexId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeBuilder setLocalVertexId(final Uint64 value) {
        this._localVertexId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Edge#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Edge#getRemoteVertexId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeBuilder setRemoteVertexId(final Uint64 value) {
        this._remoteVertexId = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public EdgeBuilder addAugmentation(Augmentation<Edge> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public EdgeBuilder removeAugmentation(Class<? extends Augmentation<Edge>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Edge} instance.
     *
     * @return A new {@link Edge} instance.
     */
    public @NonNull Edge build() {
        return new EdgeImpl(this);
    }

    private static final class EdgeImpl
        extends AbstractAugmentable<Edge>
        implements Edge {
    
        private final EdgeAttributes _edgeAttributes;
        private final Uint64 _edgeId;
        private final Uint64 _localVertexId;
        private final String _name;
        private final Uint64 _remoteVertexId;
        private final EdgeKey key;
    
        EdgeImpl(EdgeBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new EdgeKey(base.getEdgeId());
            }
            this._edgeId = key.getEdgeId();
            this._edgeAttributes = base.getEdgeAttributes();
            this._localVertexId = base.getLocalVertexId();
            this._name = base.getName();
            this._remoteVertexId = base.getRemoteVertexId();
        }
    
        @Override
        public EdgeKey key() {
            return key;
        }
        
        @Override
        public EdgeAttributes getEdgeAttributes() {
            return _edgeAttributes;
        }
        
        @Override
        public Uint64 getEdgeId() {
            return _edgeId;
        }
        
        @Override
        public Uint64 getLocalVertexId() {
            return _localVertexId;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public Uint64 getRemoteVertexId() {
            return _remoteVertexId;
        }
    
        @Override
        public EdgeAttributes nonnullEdgeAttributes() {
            return Objects.requireNonNullElse(getEdgeAttributes(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.EdgeAttributesBuilder.empty());
        }
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Edge.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Edge.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Edge.bindingToString(this);
        }
    }
}
