package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link Prefix} class.
 *
 * @see Prefix
 *
 */
@Generated("mdsal-binding-generator")
public class PrefixKey
 implements Identifier<Prefix> {
    private static final long serialVersionUID = 6237631375778515810L;
    private final IpPrefix _prefix;


    /**
     * Constructs an instance.
     *
     * @param _prefix the entity prefix
     * @throws NullPointerException if any of the arguments are null
     */
    public PrefixKey(@NonNull IpPrefix _prefix) {
        this._prefix = CodeHelpers.requireKeyProp(_prefix, "prefix");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public PrefixKey(PrefixKey source) {
        this._prefix = source._prefix;
    }


    /**
     * Return prefix, guaranteed to be non-null.
     *
     * @return {@code IpPrefix} prefix, guaranteed to be non-null.
     */
    public @NonNull IpPrefix getPrefix() {
        return _prefix;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_prefix);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof PrefixKey other
            && Objects.equals(_prefix, other._prefix);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(PrefixKey.class);
        CodeHelpers.appendValue(helper, "prefix", _prefix);
        return helper.toString();
    }
}

