package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Vertex.VertexType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.vertex.Srgb;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * Class that builds {@link Vertex} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Vertex createVertex(int fooXyzzy, int barBaz) {
 *         return new VertexBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Vertex, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Vertex
 *
 */
@Generated("mdsal-binding-generator")
public class VertexBuilder {

    private Uint32 _asn;
    private String _name;
    private Ipv4Address _routerId;
    private Ipv6Address _routerId6;
    private Srgb _srgb;
    private Uint64 _vertexId;
    private VertexType _vertexType;
    private VertexKey key;


    Map<Class<? extends Augmentation<Vertex>>, Augmentation<Vertex>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public VertexBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Vertex}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Vertex from which the builder should be initialized
     */
    public VertexBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Vertex arg) {
        this._vertexId = arg.getVertexId();
        this._name = arg.getName();
        this._routerId = arg.getRouterId();
        this._routerId6 = arg.getRouterId6();
        this._vertexType = arg.getVertexType();
        this._srgb = arg.getSrgb();
        this._asn = arg.getAsn();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Vertex}.
     *
     * @param base Vertex from which the builder should be initialized
     */
    public VertexBuilder(Vertex base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._vertexId = base.getVertexId();
        this._asn = base.getAsn();
        this._name = base.getName();
        this._routerId = base.getRouterId();
        this._routerId6 = base.getRouterId6();
        this._srgb = base.getSrgb();
        this._vertexType = base.getVertexType();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Vertex}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Vertex castArg) {
            this._vertexId = castArg.getVertexId();
            this._name = castArg.getName();
            this._routerId = castArg.getRouterId();
            this._routerId6 = castArg.getRouterId6();
            this._vertexType = castArg.getVertexType();
            this._srgb = castArg.getSrgb();
            this._asn = castArg.getAsn();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Vertex]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Vertex#key()}.
     *
     * @return current value
     */
    public VertexKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Vertex#getAsn()}.
     *
     * @return current value
     */
    public Uint32 getAsn() {
        return _asn;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Vertex#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Vertex#getRouterId()}.
     *
     * @return current value
     */
    public Ipv4Address getRouterId() {
        return _routerId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Vertex#getRouterId6()}.
     *
     * @return current value
     */
    public Ipv6Address getRouterId6() {
        return _routerId6;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Vertex#getSrgb()}.
     *
     * @return current value
     */
    public Srgb getSrgb() {
        return _srgb;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Vertex#getVertexId()}.
     *
     * @return current value
     */
    public Uint64 getVertexId() {
        return _vertexId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Vertex#getVertexType()}.
     *
     * @return current value
     */
    public VertexType getVertexType() {
        return _vertexType;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Vertex>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Vertex#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public VertexBuilder withKey(final VertexKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Vertex#getAsn()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public VertexBuilder setAsn(final Uint32 value) {
        this._asn = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Vertex#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public VertexBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Vertex#getRouterId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public VertexBuilder setRouterId(final Ipv4Address value) {
        this._routerId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Vertex#getRouterId6()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public VertexBuilder setRouterId6(final Ipv6Address value) {
        this._routerId6 = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Vertex#getSrgb()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public VertexBuilder setSrgb(final Srgb value) {
        this._srgb = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Vertex#getVertexId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public VertexBuilder setVertexId(final Uint64 value) {
        this._vertexId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Vertex#getVertexType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public VertexBuilder setVertexType(final VertexType value) {
        this._vertexType = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public VertexBuilder addAugmentation(Augmentation<Vertex> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public VertexBuilder removeAugmentation(Class<? extends Augmentation<Vertex>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Vertex} instance.
     *
     * @return A new {@link Vertex} instance.
     */
    public @NonNull Vertex build() {
        return new VertexImpl(this);
    }

    private static final class VertexImpl
        extends AbstractAugmentable<Vertex>
        implements Vertex {
    
        private final Uint32 _asn;
        private final String _name;
        private final Ipv4Address _routerId;
        private final Ipv6Address _routerId6;
        private final Srgb _srgb;
        private final Uint64 _vertexId;
        private final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Vertex.VertexType _vertexType;
        private final VertexKey key;
    
        VertexImpl(VertexBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new VertexKey(base.getVertexId());
            }
            this._vertexId = key.getVertexId();
            this._asn = base.getAsn();
            this._name = base.getName();
            this._routerId = base.getRouterId();
            this._routerId6 = base.getRouterId6();
            this._srgb = base.getSrgb();
            this._vertexType = base.getVertexType();
        }
    
        @Override
        public VertexKey key() {
            return key;
        }
        
        @Override
        public Uint32 getAsn() {
            return _asn;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public Ipv4Address getRouterId() {
            return _routerId;
        }
        
        @Override
        public Ipv6Address getRouterId6() {
            return _routerId6;
        }
        
        @Override
        public Srgb getSrgb() {
            return _srgb;
        }
        
        @Override
        public Uint64 getVertexId() {
            return _vertexId;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Vertex.VertexType getVertexType() {
            return _vertexType;
        }
    
        
        
        
        
        @Override
        public Srgb nonnullSrgb() {
            return Objects.requireNonNullElse(getSrgb(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.vertex.SrgbBuilder.empty());
        }
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Vertex.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Vertex.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Vertex.bindingToString(this);
        }
    }
}
