package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * This class represents the key of {@link Vertex} class.
 *
 * @see Vertex
 *
 */
@Generated("mdsal-binding-generator")
public class VertexKey
 implements Identifier<Vertex> {
    private static final long serialVersionUID = 7055492529607486973L;
    private final Uint64 _vertexId;


    /**
     * Constructs an instance.
     *
     * @param _vertexId the entity vertexId
     * @throws NullPointerException if any of the arguments are null
     */
    public VertexKey(@NonNull Uint64 _vertexId) {
        this._vertexId = CodeHelpers.requireKeyProp(_vertexId, "vertexId");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public VertexKey(VertexKey source) {
        this._vertexId = source._vertexId;
    }


    /**
     * Return vertexId, guaranteed to be non-null.
     *
     * @return {@code Uint64} vertexId, guaranteed to be non-null.
     */
    public @NonNull Uint64 getVertexId() {
        return _vertexId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_vertexId);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof VertexKey other
            && Objects.equals(_vertexId, other._vertexId);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(VertexKey.class);
        CodeHelpers.appendValue(helper, "vertexId", _vertexId);
        return helper.toString();
    }
}

