package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.vertex;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link Srgb} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Srgb createSrgb(int fooXyzzy, int barBaz) {
 *         return new SrgbBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Srgb, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Srgb
 *
 */
@Generated("mdsal-binding-generator")
public class SrgbBuilder {

    private Uint32 _lowerBound;
    private Uint32 _rangeSize;


    Map<Class<? extends Augmentation<Srgb>>, Augmentation<Srgb>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public SrgbBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Srgb}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Srgb from which the builder should be initialized
     */
    public SrgbBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Srgb arg) {
        this._lowerBound = arg.getLowerBound();
        this._rangeSize = arg.getRangeSize();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Srgb}.
     *
     * @param base Srgb from which the builder should be initialized
     */
    public SrgbBuilder(Srgb base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._lowerBound = base.getLowerBound();
        this._rangeSize = base.getRangeSize();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Srgb}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Srgb castArg) {
            this._lowerBound = castArg.getLowerBound();
            this._rangeSize = castArg.getRangeSize();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Srgb]");
    }

    private static final class LazyEmpty {
        static final @NonNull Srgb INSTANCE = new SrgbBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Srgb.
     *
     * @return An empty {@link Srgb}
     */
    public static @NonNull Srgb empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Srgb#getLowerBound()}.
     *
     * @return current value
     */
    public Uint32 getLowerBound() {
        return _lowerBound;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Srgb#getRangeSize()}.
     *
     * @return current value
     */
    public Uint32 getRangeSize() {
        return _rangeSize;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Srgb>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Srgb#getLowerBound()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SrgbBuilder setLowerBound(final Uint32 value) {
        this._lowerBound = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Srgb#getRangeSize()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SrgbBuilder setRangeSize(final Uint32 value) {
        this._rangeSize = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SrgbBuilder addAugmentation(Augmentation<Srgb> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SrgbBuilder removeAugmentation(Class<? extends Augmentation<Srgb>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Srgb} instance.
     *
     * @return A new {@link Srgb} instance.
     */
    public @NonNull Srgb build() {
        return new SrgbImpl(this);
    }

    private static final class SrgbImpl
        extends AbstractAugmentable<Srgb>
        implements Srgb {
    
        private final Uint32 _lowerBound;
        private final Uint32 _rangeSize;
    
        SrgbImpl(SrgbBuilder base) {
            super(base.augmentation);
            this._lowerBound = base.getLowerBound();
            this._rangeSize = base.getRangeSize();
        }
    
        @Override
        public Uint32 getLowerBound() {
            return _lowerBound;
        }
        
        @Override
        public Uint32 getRangeSize() {
            return _rangeSize;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Srgb.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Srgb.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Srgb.bindingToString(this);
        }
    }
}
