/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Range;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Decimal64;

public class DecimalBandwidth
implements ScalarTypeObject<Decimal64>,
Serializable {
    private static final long serialVersionUID = 8069688163137208190L;
    public static final String _UNITS = "bytes/second";
    private final Decimal64 _value;
    private static final Range<Decimal64>[] CHECK_VALUERANGE_RANGES;

    private static void check_valueRange(Decimal64 value) {
        for (Range<Decimal64> r : CHECK_VALUERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        CodeHelpers.throwInvalidRange((Object[])CHECK_VALUERANGE_RANGES, (Object)value);
    }

    @ConstructorParameters(value={"value"})
    public DecimalBandwidth(Decimal64 _value) {
        if (_value != null) {
            DecimalBandwidth.check_valueRange(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public DecimalBandwidth(DecimalBandwidth source) {
        this._value = source._value;
    }

    public static DecimalBandwidth getDefaultInstance(String defaultValue) {
        return new DecimalBandwidth(Decimal64.valueOf((String)defaultValue));
    }

    public Decimal64 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DecimalBandwidth)) return false;
        DecimalBandwidth other = (DecimalBandwidth)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(DecimalBandwidth.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"UNITS", (Object)_UNITS);
        return helper.toString();
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)Decimal64.of((int)2, (long)Long.MIN_VALUE), (Comparable)Decimal64.of((int)2, (long)Long.MAX_VALUE));
        CHECK_VALUERANGE_RANGES = a;
    }
}

