package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * grouping prefix {
 *   leaf prefix {
 *     type inet:ip-prefix;
 *   }
 *   leaf prefix-sid {
 *     type uint32;
 *   }
 *   leaf node-sid {
 *     type boolean;
 *   }
 *   leaf vertex-id {
 *     type uint64;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface Prefix
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("prefix");

    @Override
    Class<? extends Prefix> implementedInterface();
    
    /**
     * Return prefix, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         IP (v4 or v6) Prefix.
     *     </code>
     * </pre>
     *
     * @return {@code IpPrefix} prefix, or {@code null} if it is not present.
     *
     */
    IpPrefix getPrefix();
    
    /**
     * Return prefix, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         IP (v4 or v6) Prefix.
     *     </code>
     * </pre>
     *
     * @return {@code IpPrefix} prefix, guaranteed to be non-null.
     * @throws NoSuchElementException if prefix is not present
     *
     */
    default @NonNull IpPrefix requirePrefix() {
        return CodeHelpers.require(getPrefix(), "prefix");
    }
    
    /**
     * Return prefixSid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Segment Routing prefix Identifier. Unit MPLS label
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} prefixSid, or {@code null} if it is not present.
     *
     */
    Uint32 getPrefixSid();
    
    /**
     * Return prefixSid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Segment Routing prefix Identifier. Unit MPLS label
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} prefixSid, guaranteed to be non-null.
     * @throws NoSuchElementException if prefixSid is not present
     *
     */
    default @NonNull Uint32 requirePrefixSid() {
        return CodeHelpers.require(getPrefixSid(), "prefixsid");
    }
    
    /**
     * Return nodeSid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Prefix is a Node Segment Routing Identifier (Node-SID)
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} nodeSid, or {@code null} if it is not present.
     *
     */
    Boolean getNodeSid();
    
    /**
     * Return nodeSid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Prefix is a Node Segment Routing Identifier (Node-SID)
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} nodeSid, guaranteed to be non-null.
     * @throws NoSuchElementException if nodeSid is not present
     *
     */
    default @NonNull Boolean requireNodeSid() {
        return CodeHelpers.require(getNodeSid(), "nodesid");
    }
    
    /**
     * Return vertexId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reference to the Vertex where the prefix is attached
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} vertexId, or {@code null} if it is not present.
     *
     */
    Uint64 getVertexId();
    
    /**
     * Return vertexId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Reference to the Vertex where the prefix is attached
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} vertexId, guaranteed to be non-null.
     * @throws NoSuchElementException if vertexId is not present
     *
     */
    default @NonNull Uint64 requireVertexId() {
        return CodeHelpers.require(getVertexId(), "vertexid");
    }

}

