package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * This class represents the key of {@link Edge} class.
 *
 * @see Edge
 *
 */
@Generated("mdsal-binding-generator")
public class EdgeKey
 implements Identifier<Edge> {
    @java.io.Serial
    private static final long serialVersionUID = 441729458803676756L;
    private final Uint64 _edgeId;


    /**
     * Constructs an instance.
     *
     * @param _edgeId the entity edgeId
     * @throws NullPointerException if any of the arguments are null
     */
    public EdgeKey(@NonNull Uint64 _edgeId) {
        this._edgeId = CodeHelpers.requireKeyProp(_edgeId, "edgeId");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public EdgeKey(EdgeKey source) {
        this._edgeId = source._edgeId;
    }


    /**
     * Return edgeId, guaranteed to be non-null.
     *
     * @return {@code Uint64} edgeId, guaranteed to be non-null.
     */
    public @NonNull Uint64 getEdgeId() {
        return _edgeId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_edgeId);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof EdgeKey other
            && Objects.equals(_edgeId, other._edgeId);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(EdgeKey.class);
        CodeHelpers.appendValue(helper, "edgeId", _edgeId);
        return helper.toString();
    }
}

