/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.GraphTopology;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.Graph;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.GraphKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class GraphTopologyBuilder {
    private Map<GraphKey, Graph> _graph;
    Map<Class<? extends Augmentation<GraphTopology>>, Augmentation<GraphTopology>> augmentation = Map.of();

    public GraphTopologyBuilder() {
    }

    public GraphTopologyBuilder(GraphTopology base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GraphTopology>>, Augmentation<GraphTopology>>(aug);
        }
        this._graph = base.getGraph();
    }

    public static @NonNull GraphTopology empty() {
        return LazyEmpty.INSTANCE;
    }

    public Map<GraphKey, Graph> getGraph() {
        return this._graph;
    }

    public <E$$ extends Augmentation<GraphTopology>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public GraphTopologyBuilder setGraph(Map<GraphKey, Graph> values) {
        this._graph = values;
        return this;
    }

    public GraphTopologyBuilder addAugmentation(Augmentation<GraphTopology> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GraphTopology>>, Augmentation<GraphTopology>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public GraphTopologyBuilder removeAugmentation(Class<? extends Augmentation<GraphTopology>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull GraphTopology build() {
        return new GraphTopologyImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull GraphTopology INSTANCE = new GraphTopologyBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class GraphTopologyImpl
    extends AbstractAugmentable<GraphTopology>
    implements GraphTopology {
        private final Map<GraphKey, Graph> _graph;
        private int hash = 0;
        private volatile boolean hashValid = false;

        GraphTopologyImpl(GraphTopologyBuilder base) {
            super(base.augmentation);
            this._graph = CodeHelpers.emptyToNull(base.getGraph());
        }

        @Override
        public Map<GraphKey, Graph> getGraph() {
            return this._graph;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = GraphTopology.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return GraphTopology.bindingEquals(this, obj);
        }

        public String toString() {
            return GraphTopology.bindingToString(this);
        }
    }
}

