package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Segment Routing Global Block: lower-bound + range-size
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * grouping srgb {
 *   leaf lower-bound {
 *     type uint32;
 *   }
 *   leaf range-size {
 *     type uint32;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface Srgb
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("srgb");

    @Override
    Class<? extends Srgb> implementedInterface();
    
    /**
     * Return lowerBound, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Lower bound of label range in SRGB. Unit MPLS label
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} lowerBound, or {@code null} if it is not present.
     *
     */
    Uint32 getLowerBound();
    
    /**
     * Return lowerBound, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Lower bound of label range in SRGB. Unit MPLS label
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} lowerBound, guaranteed to be non-null.
     * @throws NoSuchElementException if lowerBound is not present
     *
     */
    default @NonNull Uint32 requireLowerBound() {
        return CodeHelpers.require(getLowerBound(), "lowerbound");
    }
    
    /**
     * Return rangeSize, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Label range size in SRGB. Unit MPLS label
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} rangeSize, or {@code null} if it is not present.
     *
     */
    Uint32 getRangeSize();
    
    /**
     * Return rangeSize, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Label range size in SRGB. Unit MPLS label
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} rangeSize, guaranteed to be non-null.
     * @throws NoSuchElementException if rangeSize is not present
     *
     */
    default @NonNull Uint32 requireRangeSize() {
        return CodeHelpers.require(getRangeSize(), "rangesize");
    }

}

