package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Edge;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * All attributes associated to the Edge
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * container edge-attributes {
 *   uses edge-attributes;
 * }
 * </pre>
 * <p>To create instances of this class use {@link EdgeAttributesBuilder}.
 * @see EdgeAttributesBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface EdgeAttributes
    extends
    ChildOf<Edge>,
    Augmentable<EdgeAttributes>,
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.EdgeAttributes
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("edge-attributes");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.EdgeAttributes> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.EdgeAttributes.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.@NonNull EdgeAttributes obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getAdjSid());
        result = prime * result + Objects.hashCode(obj.getAdjSid6());
        result = prime * result + Objects.hashCode(obj.getAdminGroup());
        result = prime * result + Objects.hashCode(obj.getAvailableBandwidth());
        result = prime * result + Objects.hashCode(obj.getBackupAdjSid());
        result = prime * result + Objects.hashCode(obj.getBackupAdjSid6());
        result = prime * result + Objects.hashCode(obj.getDelay());
        result = prime * result + Objects.hashCode(obj.getJitter());
        result = prime * result + Objects.hashCode(obj.getLocalAddress());
        result = prime * result + Objects.hashCode(obj.getLocalAddress6());
        result = prime * result + Objects.hashCode(obj.getLocalIdentifier());
        result = prime * result + Objects.hashCode(obj.getLoss());
        result = prime * result + Objects.hashCode(obj.getMaxLinkBandwidth());
        result = prime * result + Objects.hashCode(obj.getMaxResvLinkBandwidth());
        result = prime * result + Objects.hashCode(obj.getMetric());
        result = prime * result + Objects.hashCode(obj.getMinMaxDelay());
        result = prime * result + Objects.hashCode(obj.getRemoteAddress());
        result = prime * result + Objects.hashCode(obj.getRemoteAddress6());
        result = prime * result + Objects.hashCode(obj.getRemoteIdentifier());
        result = prime * result + Objects.hashCode(obj.getResidualBandwidth());
        result = prime * result + Objects.hashCode(obj.getSrlgs());
        result = prime * result + Objects.hashCode(obj.getTeMetric());
        result = prime * result + Objects.hashCode(obj.getUnreservedBandwidth());
        result = prime * result + Objects.hashCode(obj.getUtilizedBandwidth());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.@NonNull EdgeAttributes thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.EdgeAttributes.class, obj);
        return other != null
            && Objects.equals(thisObj.getAdjSid(), other.getAdjSid())
            && Objects.equals(thisObj.getAdjSid6(), other.getAdjSid6())
            && Objects.equals(thisObj.getAdminGroup(), other.getAdminGroup())
            && Objects.equals(thisObj.getAvailableBandwidth(), other.getAvailableBandwidth())
            && Objects.equals(thisObj.getBackupAdjSid(), other.getBackupAdjSid())
            && Objects.equals(thisObj.getBackupAdjSid6(), other.getBackupAdjSid6())
            && Objects.equals(thisObj.getDelay(), other.getDelay())
            && Objects.equals(thisObj.getJitter(), other.getJitter())
            && Objects.equals(thisObj.getLocalIdentifier(), other.getLocalIdentifier())
            && Objects.equals(thisObj.getLoss(), other.getLoss())
            && Objects.equals(thisObj.getMaxLinkBandwidth(), other.getMaxLinkBandwidth())
            && Objects.equals(thisObj.getMaxResvLinkBandwidth(), other.getMaxResvLinkBandwidth())
            && Objects.equals(thisObj.getMetric(), other.getMetric())
            && Objects.equals(thisObj.getRemoteIdentifier(), other.getRemoteIdentifier())
            && Objects.equals(thisObj.getResidualBandwidth(), other.getResidualBandwidth())
            && Objects.equals(thisObj.getTeMetric(), other.getTeMetric())
            && Objects.equals(thisObj.getUtilizedBandwidth(), other.getUtilizedBandwidth())
            && Objects.equals(thisObj.getLocalAddress(), other.getLocalAddress())
            && Objects.equals(thisObj.getLocalAddress6(), other.getLocalAddress6())
            && Objects.equals(thisObj.getRemoteAddress(), other.getRemoteAddress())
            && Objects.equals(thisObj.getRemoteAddress6(), other.getRemoteAddress6())
            && Objects.equals(thisObj.getMinMaxDelay(), other.getMinMaxDelay())
            && Objects.equals(thisObj.getSrlgs(), other.getSrlgs())
            && Objects.equals(thisObj.getUnreservedBandwidth(), other.getUnreservedBandwidth())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.@NonNull EdgeAttributes obj) {
        final var helper = MoreObjects.toStringHelper("EdgeAttributes");
        CodeHelpers.appendValue(helper, "adjSid", obj.getAdjSid());
        CodeHelpers.appendValue(helper, "adjSid6", obj.getAdjSid6());
        CodeHelpers.appendValue(helper, "adminGroup", obj.getAdminGroup());
        CodeHelpers.appendValue(helper, "availableBandwidth", obj.getAvailableBandwidth());
        CodeHelpers.appendValue(helper, "backupAdjSid", obj.getBackupAdjSid());
        CodeHelpers.appendValue(helper, "backupAdjSid6", obj.getBackupAdjSid6());
        CodeHelpers.appendValue(helper, "delay", obj.getDelay());
        CodeHelpers.appendValue(helper, "jitter", obj.getJitter());
        CodeHelpers.appendValue(helper, "localAddress", obj.getLocalAddress());
        CodeHelpers.appendValue(helper, "localAddress6", obj.getLocalAddress6());
        CodeHelpers.appendValue(helper, "localIdentifier", obj.getLocalIdentifier());
        CodeHelpers.appendValue(helper, "loss", obj.getLoss());
        CodeHelpers.appendValue(helper, "maxLinkBandwidth", obj.getMaxLinkBandwidth());
        CodeHelpers.appendValue(helper, "maxResvLinkBandwidth", obj.getMaxResvLinkBandwidth());
        CodeHelpers.appendValue(helper, "metric", obj.getMetric());
        CodeHelpers.appendValue(helper, "minMaxDelay", obj.getMinMaxDelay());
        CodeHelpers.appendValue(helper, "remoteAddress", obj.getRemoteAddress());
        CodeHelpers.appendValue(helper, "remoteAddress6", obj.getRemoteAddress6());
        CodeHelpers.appendValue(helper, "remoteIdentifier", obj.getRemoteIdentifier());
        CodeHelpers.appendValue(helper, "residualBandwidth", obj.getResidualBandwidth());
        CodeHelpers.appendValue(helper, "srlgs", obj.getSrlgs());
        CodeHelpers.appendValue(helper, "teMetric", obj.getTeMetric());
        CodeHelpers.appendValue(helper, "unreservedBandwidth", obj.getUnreservedBandwidth());
        CodeHelpers.appendValue(helper, "utilizedBandwidth", obj.getUtilizedBandwidth());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

