package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.EdgeAttributes;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * Unidirectional Edge (link) representation for the network topology
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * grouping edge {
 *   leaf edge-id {
 *     type uint64;
 *   }
 *   leaf local-vertex-id {
 *     type uint64;
 *   }
 *   leaf remote-vertex-id {
 *     type uint64;
 *   }
 *   leaf name {
 *     type string;
 *   }
 *   container edge-attributes {
 *     uses edge-attributes;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface Edge
    extends
    Grouping
{




    /**
     * Return edgeId, or {@code null} if it is not present.
     *
     * @return {@code Uint64} edgeId, or {@code null} if it is not present.
     *
     */
    Uint64 getEdgeId();
    
    /**
     * Return edgeId, guaranteed to be non-null.
     *
     * @return {@code Uint64} edgeId, guaranteed to be non-null.
     * @throws NoSuchElementException if edgeId is not present
     *
     */
    default @NonNull Uint64 requireEdgeId() {
        return CodeHelpers.require(getEdgeId(), "edgeid");
    }
    
    /**
     * Return localVertexId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Vertex identifier where the Edge is attached
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} localVertexId, or {@code null} if it is not present.
     *
     */
    Uint64 getLocalVertexId();
    
    /**
     * Return localVertexId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Vertex identifier where the Edge is attached
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} localVertexId, guaranteed to be non-null.
     * @throws NoSuchElementException if localVertexId is not present
     *
     */
    default @NonNull Uint64 requireLocalVertexId() {
        return CodeHelpers.require(getLocalVertexId(), "localvertexid");
    }
    
    /**
     * Return remoteVertexId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Vertex identifier where the Edge is going to
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} remoteVertexId, or {@code null} if it is not present.
     *
     */
    Uint64 getRemoteVertexId();
    
    /**
     * Return remoteVertexId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Vertex identifier where the Edge is going to
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} remoteVertexId, guaranteed to be non-null.
     * @throws NoSuchElementException if remoteVertexId is not present
     *
     */
    default @NonNull Uint64 requireRemoteVertexId() {
        return CodeHelpers.require(getRemoteVertexId(), "remotevertexid");
    }
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Edge name
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Edge name
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return edgeAttributes, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         All attributes associated to the Edge
     *     </code>
     * </pre>
     *
     * @return {@code EdgeAttributes} edgeAttributes, or {@code null} if it is not present.
     *
     */
    EdgeAttributes getEdgeAttributes();
    
    /**
     * Return edgeAttributes, or an empty instance if it is not present.
     *
     * @return {@code EdgeAttributes} edgeAttributes, or an empty instance if it is not present.
     *
     */
    @NonNull EdgeAttributes nonnullEdgeAttributes();

}

