package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.attributes.MinMaxDelay;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.attributes.UnreservedBandwidth;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Attributes associated with the Edge
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * grouping edge-attributes {
 *   leaf metric {
 *     type uint32;
 *   }
 *   leaf te-metric {
 *     type uint32;
 *   }
 *   leaf admin-group {
 *     type uint32;
 *   }
 *   leaf local-address {
 *     type inet:ipv4-address;
 *   }
 *   leaf remote-address {
 *     type inet:ipv4-address;
 *   }
 *   leaf local-address6 {
 *     type inet:ipv6-address;
 *   }
 *   leaf remote-address6 {
 *     type inet:ipv6-address;
 *   }
 *   leaf local-identifier {
 *     type uint32;
 *   }
 *   leaf remote-identifier {
 *     type uint32;
 *   }
 *   leaf max-link-bandwidth {
 *     type decimal-bandwidth;
 *   }
 *   leaf max-resv-link-bandwidth {
 *     type decimal-bandwidth;
 *   }
 *   list unreserved-bandwidth {
 *     max-elements 8;
 *     ordered-by user;
 *     key class-type;
 *     leaf class-type {
 *       type uint8 {
 *         range 0..7;
 *       }
 *     }
 *     leaf bandwidth {
 *       type decimal-bandwidth;
 *     }
 *   }
 *   leaf delay {
 *     type delay;
 *   }
 *   container min-max-delay {
 *     leaf min-delay {
 *       type delay;
 *     }
 *     leaf max-delay {
 *       type delay;
 *     }
 *   }
 *   leaf jitter {
 *     type delay;
 *   }
 *   leaf loss {
 *     type loss;
 *   }
 *   leaf residual-bandwidth {
 *     type decimal-bandwidth;
 *   }
 *   leaf available-bandwidth {
 *     type decimal-bandwidth;
 *   }
 *   leaf utilized-bandwidth {
 *     type decimal-bandwidth;
 *   }
 *   leaf adj-sid {
 *     units "MPLS label";
 *     type uint32;
 *   }
 *   leaf backup-adj-sid {
 *     units "MPLS label";
 *     type uint32;
 *   }
 *   leaf adj-sid6 {
 *     units "MPLS label";
 *     type uint32;
 *   }
 *   leaf backup-adj-sid6 {
 *     units "MPLS label";
 *     type uint32;
 *   }
 *   leaf-list srlgs {
 *     type uint32;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface EdgeAttributes
    extends
    Grouping
{




    /**
     * Return metric, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Standard Metric from the routing protocol
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} metric, or {@code null} if it is not present.
     *
     */
    Uint32 getMetric();
    
    /**
     * Return metric, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Standard Metric from the routing protocol
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} metric, guaranteed to be non-null.
     * @throws NoSuchElementException if metric is not present
     *
     */
    default @NonNull Uint32 requireMetric() {
        return CodeHelpers.require(getMetric(), "metric");
    }
    
    /**
     * Return teMetric, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Traffic Engineering Metric
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} teMetric, or {@code null} if it is not present.
     *
     */
    Uint32 getTeMetric();
    
    /**
     * Return teMetric, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Traffic Engineering Metric
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} teMetric, guaranteed to be non-null.
     * @throws NoSuchElementException if teMetric is not present
     *
     */
    default @NonNull Uint32 requireTeMetric() {
        return CodeHelpers.require(getTeMetric(), "temetric");
    }
    
    /**
     * Return adminGroup, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Administrative group or color of the link
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} adminGroup, or {@code null} if it is not present.
     *
     */
    Uint32 getAdminGroup();
    
    /**
     * Return adminGroup, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Administrative group or color of the link
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} adminGroup, guaranteed to be non-null.
     * @throws NoSuchElementException if adminGroup is not present
     *
     */
    default @NonNull Uint32 requireAdminGroup() {
        return CodeHelpers.require(getAdminGroup(), "admingroup");
    }
    
    /**
     * Return localAddress, or {@code null} if it is not present.
     *
     * @return {@code Ipv4Address} localAddress, or {@code null} if it is not present.
     *
     */
    Ipv4Address getLocalAddress();
    
    /**
     * Return localAddress, guaranteed to be non-null.
     *
     * @return {@code Ipv4Address} localAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if localAddress is not present
     *
     */
    default @NonNull Ipv4Address requireLocalAddress() {
        return CodeHelpers.require(getLocalAddress(), "localaddress");
    }
    
    /**
     * Return remoteAddress, or {@code null} if it is not present.
     *
     * @return {@code Ipv4Address} remoteAddress, or {@code null} if it is not present.
     *
     */
    Ipv4Address getRemoteAddress();
    
    /**
     * Return remoteAddress, guaranteed to be non-null.
     *
     * @return {@code Ipv4Address} remoteAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if remoteAddress is not present
     *
     */
    default @NonNull Ipv4Address requireRemoteAddress() {
        return CodeHelpers.require(getRemoteAddress(), "remoteaddress");
    }
    
    /**
     * Return localAddress6, or {@code null} if it is not present.
     *
     * @return {@code Ipv6Address} localAddress6, or {@code null} if it is not present.
     *
     */
    Ipv6Address getLocalAddress6();
    
    /**
     * Return localAddress6, guaranteed to be non-null.
     *
     * @return {@code Ipv6Address} localAddress6, guaranteed to be non-null.
     * @throws NoSuchElementException if localAddress6 is not present
     *
     */
    default @NonNull Ipv6Address requireLocalAddress6() {
        return CodeHelpers.require(getLocalAddress6(), "localaddress6");
    }
    
    /**
     * Return remoteAddress6, or {@code null} if it is not present.
     *
     * @return {@code Ipv6Address} remoteAddress6, or {@code null} if it is not present.
     *
     */
    Ipv6Address getRemoteAddress6();
    
    /**
     * Return remoteAddress6, guaranteed to be non-null.
     *
     * @return {@code Ipv6Address} remoteAddress6, guaranteed to be non-null.
     * @throws NoSuchElementException if remoteAddress6 is not present
     *
     */
    default @NonNull Ipv6Address requireRemoteAddress6() {
        return CodeHelpers.require(getRemoteAddress6(), "remoteaddress6");
    }
    
    /**
     * Return localIdentifier, or {@code null} if it is not present.
     *
     * @return {@code Uint32} localIdentifier, or {@code null} if it is not present.
     *
     */
    Uint32 getLocalIdentifier();
    
    /**
     * Return localIdentifier, guaranteed to be non-null.
     *
     * @return {@code Uint32} localIdentifier, guaranteed to be non-null.
     * @throws NoSuchElementException if localIdentifier is not present
     *
     */
    default @NonNull Uint32 requireLocalIdentifier() {
        return CodeHelpers.require(getLocalIdentifier(), "localidentifier");
    }
    
    /**
     * Return remoteIdentifier, or {@code null} if it is not present.
     *
     * @return {@code Uint32} remoteIdentifier, or {@code null} if it is not present.
     *
     */
    Uint32 getRemoteIdentifier();
    
    /**
     * Return remoteIdentifier, guaranteed to be non-null.
     *
     * @return {@code Uint32} remoteIdentifier, guaranteed to be non-null.
     * @throws NoSuchElementException if remoteIdentifier is not present
     *
     */
    default @NonNull Uint32 requireRemoteIdentifier() {
        return CodeHelpers.require(getRemoteIdentifier(), "remoteidentifier");
    }
    
    /**
     * Return maxLinkBandwidth, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Maximum bandwidth that can be use
     *     </code>
     * </pre>
     *
     * @return {@code DecimalBandwidth} maxLinkBandwidth, or {@code null} if it is not present.
     *
     */
    DecimalBandwidth getMaxLinkBandwidth();
    
    /**
     * Return maxLinkBandwidth, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Maximum bandwidth that can be use
     *     </code>
     * </pre>
     *
     * @return {@code DecimalBandwidth} maxLinkBandwidth, guaranteed to be non-null.
     * @throws NoSuchElementException if maxLinkBandwidth is not present
     *
     */
    default @NonNull DecimalBandwidth requireMaxLinkBandwidth() {
        return CodeHelpers.require(getMaxLinkBandwidth(), "maxlinkbandwidth");
    }
    
    /**
     * Return maxResvLinkBandwidth, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Maximum amount of bandwidth that can be reserved
     *     </code>
     * </pre>
     *
     * @return {@code DecimalBandwidth} maxResvLinkBandwidth, or {@code null} if it is not present.
     *
     */
    DecimalBandwidth getMaxResvLinkBandwidth();
    
    /**
     * Return maxResvLinkBandwidth, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Maximum amount of bandwidth that can be reserved
     *     </code>
     * </pre>
     *
     * @return {@code DecimalBandwidth} maxResvLinkBandwidth, guaranteed to be non-null.
     * @throws NoSuchElementException if maxResvLinkBandwidth is not present
     *
     */
    default @NonNull DecimalBandwidth requireMaxResvLinkBandwidth() {
        return CodeHelpers.require(getMaxResvLinkBandwidth(), "maxresvlinkbandwidth");
    }
    
    /**
     * Return unreservedBandwidth, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Unreserved bandwidth for 0-7 class type
     *     </code>
     * </pre>
     *
     * @return {@code List<UnreservedBandwidth>} unreservedBandwidth, or {@code null} if it is not present.
     *
     */
    @Nullable List<UnreservedBandwidth> getUnreservedBandwidth();
    
    /**
     * Return unreservedBandwidth, or an empty list if it is not present.
     *
     * @return {@code List<UnreservedBandwidth>} unreservedBandwidth, or an empty list if it is not present.
     *
     */
    default @NonNull List<UnreservedBandwidth> nonnullUnreservedBandwidth() {
        return CodeHelpers.nonnull(getUnreservedBandwidth());
    }
    
    /**
     * Return delay, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Unidirectional Delay.
     *     </code>
     * </pre>
     *
     * @return {@code Delay} delay, or {@code null} if it is not present.
     *
     */
    Delay getDelay();
    
    /**
     * Return delay, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Unidirectional Delay.
     *     </code>
     * </pre>
     *
     * @return {@code Delay} delay, guaranteed to be non-null.
     * @throws NoSuchElementException if delay is not present
     *
     */
    default @NonNull Delay requireDelay() {
        return CodeHelpers.require(getDelay(), "delay");
    }
    
    /**
     * Return minMaxDelay, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Min/Max Unidirectional Delay
     *     </code>
     * </pre>
     *
     * @return {@code MinMaxDelay} minMaxDelay, or {@code null} if it is not present.
     *
     */
    MinMaxDelay getMinMaxDelay();
    
    /**
     * Return minMaxDelay, or an empty instance if it is not present.
     *
     * @return {@code MinMaxDelay} minMaxDelay, or an empty instance if it is not present.
     *
     */
    @NonNull MinMaxDelay nonnullMinMaxDelay();
    
    /**
     * Return jitter, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Unidirectional Delay Variation
     *     </code>
     * </pre>
     *
     * @return {@code Delay} jitter, or {@code null} if it is not present.
     *
     */
    Delay getJitter();
    
    /**
     * Return jitter, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Unidirectional Delay Variation
     *     </code>
     * </pre>
     *
     * @return {@code Delay} jitter, guaranteed to be non-null.
     * @throws NoSuchElementException if jitter is not present
     *
     */
    default @NonNull Delay requireJitter() {
        return CodeHelpers.require(getJitter(), "jitter");
    }
    
    /**
     * Return loss, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Unidirectional Loss
     *     </code>
     * </pre>
     *
     * @return {@code Loss} loss, or {@code null} if it is not present.
     *
     */
    Loss getLoss();
    
    /**
     * Return loss, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Unidirectional Loss
     *     </code>
     * </pre>
     *
     * @return {@code Loss} loss, guaranteed to be non-null.
     * @throws NoSuchElementException if loss is not present
     *
     */
    default @NonNull Loss requireLoss() {
        return CodeHelpers.require(getLoss(), "loss");
    }
    
    /**
     * Return residualBandwidth, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Unidirectional Residual Bandwidth
     *     </code>
     * </pre>
     *
     * @return {@code DecimalBandwidth} residualBandwidth, or {@code null} if it is not present.
     *
     */
    DecimalBandwidth getResidualBandwidth();
    
    /**
     * Return residualBandwidth, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Unidirectional Residual Bandwidth
     *     </code>
     * </pre>
     *
     * @return {@code DecimalBandwidth} residualBandwidth, guaranteed to be non-null.
     * @throws NoSuchElementException if residualBandwidth is not present
     *
     */
    default @NonNull DecimalBandwidth requireResidualBandwidth() {
        return CodeHelpers.require(getResidualBandwidth(), "residualbandwidth");
    }
    
    /**
     * Return availableBandwidth, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Unidirectional Available Bandwidth
     *     </code>
     * </pre>
     *
     * @return {@code DecimalBandwidth} availableBandwidth, or {@code null} if it is not present.
     *
     */
    DecimalBandwidth getAvailableBandwidth();
    
    /**
     * Return availableBandwidth, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Unidirectional Available Bandwidth
     *     </code>
     * </pre>
     *
     * @return {@code DecimalBandwidth} availableBandwidth, guaranteed to be non-null.
     * @throws NoSuchElementException if availableBandwidth is not present
     *
     */
    default @NonNull DecimalBandwidth requireAvailableBandwidth() {
        return CodeHelpers.require(getAvailableBandwidth(), "availablebandwidth");
    }
    
    /**
     * Return utilizedBandwidth, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Unidirectional Utilized Bandwidth
     *     </code>
     * </pre>
     *
     * @return {@code DecimalBandwidth} utilizedBandwidth, or {@code null} if it is not present.
     *
     */
    DecimalBandwidth getUtilizedBandwidth();
    
    /**
     * Return utilizedBandwidth, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Unidirectional Utilized Bandwidth
     *     </code>
     * </pre>
     *
     * @return {@code DecimalBandwidth} utilizedBandwidth, guaranteed to be non-null.
     * @throws NoSuchElementException if utilizedBandwidth is not present
     *
     */
    default @NonNull DecimalBandwidth requireUtilizedBandwidth() {
        return CodeHelpers.require(getUtilizedBandwidth(), "utilizedbandwidth");
    }
    
    /**
     * Return adjSid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Segment Routing Adjacency Identifier for IPv4
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} adjSid, or {@code null} if it is not present.
     *
     */
    Uint32 getAdjSid();
    
    /**
     * Return adjSid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Segment Routing Adjacency Identifier for IPv4
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} adjSid, guaranteed to be non-null.
     * @throws NoSuchElementException if adjSid is not present
     *
     */
    default @NonNull Uint32 requireAdjSid() {
        return CodeHelpers.require(getAdjSid(), "adjsid");
    }
    
    /**
     * Return backupAdjSid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Segment Routing Backup Adjacency Identifier for IPv4
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} backupAdjSid, or {@code null} if it is not present.
     *
     */
    Uint32 getBackupAdjSid();
    
    /**
     * Return backupAdjSid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Segment Routing Backup Adjacency Identifier for IPv4
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} backupAdjSid, guaranteed to be non-null.
     * @throws NoSuchElementException if backupAdjSid is not present
     *
     */
    default @NonNull Uint32 requireBackupAdjSid() {
        return CodeHelpers.require(getBackupAdjSid(), "backupadjsid");
    }
    
    /**
     * Return adjSid6, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Segment Routing Adjacency Identifier for IPv6
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} adjSid6, or {@code null} if it is not present.
     *
     */
    Uint32 getAdjSid6();
    
    /**
     * Return adjSid6, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Segment Routing Adjacency Identifier for IPv6
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} adjSid6, guaranteed to be non-null.
     * @throws NoSuchElementException if adjSid6 is not present
     *
     */
    default @NonNull Uint32 requireAdjSid6() {
        return CodeHelpers.require(getAdjSid6(), "adjsid6");
    }
    
    /**
     * Return backupAdjSid6, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Segment Routing Backup Adjacency Identifier for IPv6
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} backupAdjSid6, or {@code null} if it is not present.
     *
     */
    Uint32 getBackupAdjSid6();
    
    /**
     * Return backupAdjSid6, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Segment Routing Backup Adjacency Identifier for IPv6
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} backupAdjSid6, guaranteed to be non-null.
     * @throws NoSuchElementException if backupAdjSid6 is not present
     *
     */
    default @NonNull Uint32 requireBackupAdjSid6() {
        return CodeHelpers.require(getBackupAdjSid6(), "backupadjsid6");
    }
    
    /**
     * Return srlgs, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of Shared Risk Link Group Attributes
     *     </code>
     * </pre>
     *
     * @return {@code Set<Uint32>} srlgs, or {@code null} if it is not present.
     *
     */
    @Nullable Set<Uint32> getSrlgs();
    
    /**
     * Return srlgs, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         List of Shared Risk Link Group Attributes
     *     </code>
     * </pre>
     *
     * @return {@code Set<Uint32>} srlgs, guaranteed to be non-null.
     * @throws NoSuchElementException if srlgs is not present
     *
     */
    default @NonNull Set<Uint32> requireSrlgs() {
        return CodeHelpers.require(getSrlgs(), "srlgs");
    }

}

