package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.DecimalBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Delay;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Loss;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.attributes.MinMaxDelay;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.attributes.UnreservedBandwidth;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link EdgeAttributes} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     EdgeAttributes createEdgeAttributes(int fooXyzzy, int barBaz) {
 *         return new EdgeAttributesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of EdgeAttributes, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see EdgeAttributes
 *
 */
@Generated("mdsal-binding-generator")
public class EdgeAttributesBuilder {

    private Uint32 _adjSid;
    private Uint32 _adjSid6;
    private Uint32 _adminGroup;
    private DecimalBandwidth _availableBandwidth;
    private Uint32 _backupAdjSid;
    private Uint32 _backupAdjSid6;
    private Delay _delay;
    private Delay _jitter;
    private Ipv4Address _localAddress;
    private Ipv6Address _localAddress6;
    private Uint32 _localIdentifier;
    private Loss _loss;
    private DecimalBandwidth _maxLinkBandwidth;
    private DecimalBandwidth _maxResvLinkBandwidth;
    private Uint32 _metric;
    private MinMaxDelay _minMaxDelay;
    private Ipv4Address _remoteAddress;
    private Ipv6Address _remoteAddress6;
    private Uint32 _remoteIdentifier;
    private DecimalBandwidth _residualBandwidth;
    private Set<Uint32> _srlgs;
    private Uint32 _teMetric;
    private List<UnreservedBandwidth> _unreservedBandwidth;
    private DecimalBandwidth _utilizedBandwidth;


    Map<Class<? extends Augmentation<EdgeAttributes>>, Augmentation<EdgeAttributes>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public EdgeAttributesBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.EdgeAttributes}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.EdgeAttributes from which the builder should be initialized
     */
    public EdgeAttributesBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.EdgeAttributes arg) {
        this._metric = arg.getMetric();
        this._teMetric = arg.getTeMetric();
        this._adminGroup = arg.getAdminGroup();
        this._localAddress = arg.getLocalAddress();
        this._remoteAddress = arg.getRemoteAddress();
        this._localAddress6 = arg.getLocalAddress6();
        this._remoteAddress6 = arg.getRemoteAddress6();
        this._localIdentifier = arg.getLocalIdentifier();
        this._remoteIdentifier = arg.getRemoteIdentifier();
        this._maxLinkBandwidth = arg.getMaxLinkBandwidth();
        this._maxResvLinkBandwidth = arg.getMaxResvLinkBandwidth();
        this._unreservedBandwidth = arg.getUnreservedBandwidth();
        this._delay = arg.getDelay();
        this._minMaxDelay = arg.getMinMaxDelay();
        this._jitter = arg.getJitter();
        this._loss = arg.getLoss();
        this._residualBandwidth = arg.getResidualBandwidth();
        this._availableBandwidth = arg.getAvailableBandwidth();
        this._utilizedBandwidth = arg.getUtilizedBandwidth();
        this._adjSid = arg.getAdjSid();
        this._backupAdjSid = arg.getBackupAdjSid();
        this._adjSid6 = arg.getAdjSid6();
        this._backupAdjSid6 = arg.getBackupAdjSid6();
        this._srlgs = arg.getSrlgs();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link EdgeAttributes}.
     *
     * @param base EdgeAttributes from which the builder should be initialized
     */
    public EdgeAttributesBuilder(final EdgeAttributes base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._adjSid = base.getAdjSid();
        this._adjSid6 = base.getAdjSid6();
        this._adminGroup = base.getAdminGroup();
        this._availableBandwidth = base.getAvailableBandwidth();
        this._backupAdjSid = base.getBackupAdjSid();
        this._backupAdjSid6 = base.getBackupAdjSid6();
        this._delay = base.getDelay();
        this._jitter = base.getJitter();
        this._localAddress = base.getLocalAddress();
        this._localAddress6 = base.getLocalAddress6();
        this._localIdentifier = base.getLocalIdentifier();
        this._loss = base.getLoss();
        this._maxLinkBandwidth = base.getMaxLinkBandwidth();
        this._maxResvLinkBandwidth = base.getMaxResvLinkBandwidth();
        this._metric = base.getMetric();
        this._minMaxDelay = base.getMinMaxDelay();
        this._remoteAddress = base.getRemoteAddress();
        this._remoteAddress6 = base.getRemoteAddress6();
        this._remoteIdentifier = base.getRemoteIdentifier();
        this._residualBandwidth = base.getResidualBandwidth();
        this._srlgs = base.getSrlgs();
        this._teMetric = base.getTeMetric();
        this._unreservedBandwidth = base.getUnreservedBandwidth();
        this._utilizedBandwidth = base.getUtilizedBandwidth();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.EdgeAttributes}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.EdgeAttributes castArg) {
            this._metric = castArg.getMetric();
            this._teMetric = castArg.getTeMetric();
            this._adminGroup = castArg.getAdminGroup();
            this._localAddress = castArg.getLocalAddress();
            this._remoteAddress = castArg.getRemoteAddress();
            this._localAddress6 = castArg.getLocalAddress6();
            this._remoteAddress6 = castArg.getRemoteAddress6();
            this._localIdentifier = castArg.getLocalIdentifier();
            this._remoteIdentifier = castArg.getRemoteIdentifier();
            this._maxLinkBandwidth = castArg.getMaxLinkBandwidth();
            this._maxResvLinkBandwidth = castArg.getMaxResvLinkBandwidth();
            this._unreservedBandwidth = castArg.getUnreservedBandwidth();
            this._delay = castArg.getDelay();
            this._minMaxDelay = castArg.getMinMaxDelay();
            this._jitter = castArg.getJitter();
            this._loss = castArg.getLoss();
            this._residualBandwidth = castArg.getResidualBandwidth();
            this._availableBandwidth = castArg.getAvailableBandwidth();
            this._utilizedBandwidth = castArg.getUtilizedBandwidth();
            this._adjSid = castArg.getAdjSid();
            this._backupAdjSid = castArg.getBackupAdjSid();
            this._adjSid6 = castArg.getAdjSid6();
            this._backupAdjSid6 = castArg.getBackupAdjSid6();
            this._srlgs = castArg.getSrlgs();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.EdgeAttributes]");
    }

    private static final class LazyEmpty {
        static final @NonNull EdgeAttributes INSTANCE = new EdgeAttributesBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of EdgeAttributes.
     *
     * @return An empty {@link EdgeAttributes}
     */
    public static @NonNull EdgeAttributes empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getAdjSid()}.
     *
     * @return current value
     */
    public Uint32 getAdjSid() {
        return _adjSid;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getAdjSid6()}.
     *
     * @return current value
     */
    public Uint32 getAdjSid6() {
        return _adjSid6;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getAdminGroup()}.
     *
     * @return current value
     */
    public Uint32 getAdminGroup() {
        return _adminGroup;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getAvailableBandwidth()}.
     *
     * @return current value
     */
    public DecimalBandwidth getAvailableBandwidth() {
        return _availableBandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getBackupAdjSid()}.
     *
     * @return current value
     */
    public Uint32 getBackupAdjSid() {
        return _backupAdjSid;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getBackupAdjSid6()}.
     *
     * @return current value
     */
    public Uint32 getBackupAdjSid6() {
        return _backupAdjSid6;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getDelay()}.
     *
     * @return current value
     */
    public Delay getDelay() {
        return _delay;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getJitter()}.
     *
     * @return current value
     */
    public Delay getJitter() {
        return _jitter;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getLocalAddress()}.
     *
     * @return current value
     */
    public Ipv4Address getLocalAddress() {
        return _localAddress;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getLocalAddress6()}.
     *
     * @return current value
     */
    public Ipv6Address getLocalAddress6() {
        return _localAddress6;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getLocalIdentifier()}.
     *
     * @return current value
     */
    public Uint32 getLocalIdentifier() {
        return _localIdentifier;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getLoss()}.
     *
     * @return current value
     */
    public Loss getLoss() {
        return _loss;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getMaxLinkBandwidth()}.
     *
     * @return current value
     */
    public DecimalBandwidth getMaxLinkBandwidth() {
        return _maxLinkBandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getMaxResvLinkBandwidth()}.
     *
     * @return current value
     */
    public DecimalBandwidth getMaxResvLinkBandwidth() {
        return _maxResvLinkBandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getMetric()}.
     *
     * @return current value
     */
    public Uint32 getMetric() {
        return _metric;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getMinMaxDelay()}.
     *
     * @return current value
     */
    public MinMaxDelay getMinMaxDelay() {
        return _minMaxDelay;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getRemoteAddress()}.
     *
     * @return current value
     */
    public Ipv4Address getRemoteAddress() {
        return _remoteAddress;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getRemoteAddress6()}.
     *
     * @return current value
     */
    public Ipv6Address getRemoteAddress6() {
        return _remoteAddress6;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getRemoteIdentifier()}.
     *
     * @return current value
     */
    public Uint32 getRemoteIdentifier() {
        return _remoteIdentifier;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getResidualBandwidth()}.
     *
     * @return current value
     */
    public DecimalBandwidth getResidualBandwidth() {
        return _residualBandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getSrlgs()}.
     *
     * @return current value
     */
    public Set<Uint32> getSrlgs() {
        return _srlgs;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getTeMetric()}.
     *
     * @return current value
     */
    public Uint32 getTeMetric() {
        return _teMetric;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getUnreservedBandwidth()}.
     *
     * @return current value
     */
    public List<UnreservedBandwidth> getUnreservedBandwidth() {
        return _unreservedBandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link EdgeAttributes#getUtilizedBandwidth()}.
     *
     * @return current value
     */
    public DecimalBandwidth getUtilizedBandwidth() {
        return _utilizedBandwidth;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<EdgeAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getAdjSid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setAdjSid(final Uint32 value) {
        this._adjSid = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getAdjSid6()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setAdjSid6(final Uint32 value) {
        this._adjSid6 = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getAdminGroup()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setAdminGroup(final Uint32 value) {
        this._adminGroup = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getAvailableBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setAvailableBandwidth(final DecimalBandwidth value) {
        this._availableBandwidth = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getBackupAdjSid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setBackupAdjSid(final Uint32 value) {
        this._backupAdjSid = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getBackupAdjSid6()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setBackupAdjSid6(final Uint32 value) {
        this._backupAdjSid6 = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getDelay()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setDelay(final Delay value) {
        this._delay = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getJitter()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setJitter(final Delay value) {
        this._jitter = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getLocalAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setLocalAddress(final Ipv4Address value) {
        this._localAddress = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getLocalAddress6()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setLocalAddress6(final Ipv6Address value) {
        this._localAddress6 = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getLocalIdentifier()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setLocalIdentifier(final Uint32 value) {
        this._localIdentifier = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getLoss()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setLoss(final Loss value) {
        this._loss = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getMaxLinkBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setMaxLinkBandwidth(final DecimalBandwidth value) {
        this._maxLinkBandwidth = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getMaxResvLinkBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setMaxResvLinkBandwidth(final DecimalBandwidth value) {
        this._maxResvLinkBandwidth = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getMetric()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setMetric(final Uint32 value) {
        this._metric = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getMinMaxDelay()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setMinMaxDelay(final MinMaxDelay value) {
        this._minMaxDelay = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getRemoteAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setRemoteAddress(final Ipv4Address value) {
        this._remoteAddress = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getRemoteAddress6()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setRemoteAddress6(final Ipv6Address value) {
        this._remoteAddress6 = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getRemoteIdentifier()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setRemoteIdentifier(final Uint32 value) {
        this._remoteIdentifier = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getResidualBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setResidualBandwidth(final DecimalBandwidth value) {
        this._residualBandwidth = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getSrlgs()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setSrlgs(final Set<Uint32> values) {
        this._srlgs = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getTeMetric()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setTeMetric(final Uint32 value) {
        this._teMetric = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getUnreservedBandwidth()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setUnreservedBandwidth(final List<UnreservedBandwidth> values) {
        this._unreservedBandwidth = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link EdgeAttributes#getUtilizedBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EdgeAttributesBuilder setUtilizedBandwidth(final DecimalBandwidth value) {
        this._utilizedBandwidth = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public EdgeAttributesBuilder addAugmentation(Augmentation<EdgeAttributes> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public EdgeAttributesBuilder removeAugmentation(Class<? extends Augmentation<EdgeAttributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link EdgeAttributes} instance.
     *
     * @return A new {@link EdgeAttributes} instance.
     */
    public @NonNull EdgeAttributes build() {
        return new EdgeAttributesImpl(this);
    }

    private static final class EdgeAttributesImpl
        extends AbstractAugmentable<EdgeAttributes>
        implements EdgeAttributes {
    
        private final Uint32 _adjSid;
        private final Uint32 _adjSid6;
        private final Uint32 _adminGroup;
        private final DecimalBandwidth _availableBandwidth;
        private final Uint32 _backupAdjSid;
        private final Uint32 _backupAdjSid6;
        private final Delay _delay;
        private final Delay _jitter;
        private final Ipv4Address _localAddress;
        private final Ipv6Address _localAddress6;
        private final Uint32 _localIdentifier;
        private final Loss _loss;
        private final DecimalBandwidth _maxLinkBandwidth;
        private final DecimalBandwidth _maxResvLinkBandwidth;
        private final Uint32 _metric;
        private final MinMaxDelay _minMaxDelay;
        private final Ipv4Address _remoteAddress;
        private final Ipv6Address _remoteAddress6;
        private final Uint32 _remoteIdentifier;
        private final DecimalBandwidth _residualBandwidth;
        private final Set<Uint32> _srlgs;
        private final Uint32 _teMetric;
        private final List<UnreservedBandwidth> _unreservedBandwidth;
        private final DecimalBandwidth _utilizedBandwidth;
    
        EdgeAttributesImpl(final EdgeAttributesBuilder base) {
            super(base.augmentation);
            this._adjSid = base.getAdjSid();
            this._adjSid6 = base.getAdjSid6();
            this._adminGroup = base.getAdminGroup();
            this._availableBandwidth = base.getAvailableBandwidth();
            this._backupAdjSid = base.getBackupAdjSid();
            this._backupAdjSid6 = base.getBackupAdjSid6();
            this._delay = base.getDelay();
            this._jitter = base.getJitter();
            this._localAddress = base.getLocalAddress();
            this._localAddress6 = base.getLocalAddress6();
            this._localIdentifier = base.getLocalIdentifier();
            this._loss = base.getLoss();
            this._maxLinkBandwidth = base.getMaxLinkBandwidth();
            this._maxResvLinkBandwidth = base.getMaxResvLinkBandwidth();
            this._metric = base.getMetric();
            this._minMaxDelay = base.getMinMaxDelay();
            this._remoteAddress = base.getRemoteAddress();
            this._remoteAddress6 = base.getRemoteAddress6();
            this._remoteIdentifier = base.getRemoteIdentifier();
            this._residualBandwidth = base.getResidualBandwidth();
            this._srlgs = base.getSrlgs();
            this._teMetric = base.getTeMetric();
            this._unreservedBandwidth = CodeHelpers.emptyToNull(base.getUnreservedBandwidth());
            this._utilizedBandwidth = base.getUtilizedBandwidth();
        }
    
        @Override
        public Uint32 getAdjSid() {
            return _adjSid;
        }
        
        @Override
        public Uint32 getAdjSid6() {
            return _adjSid6;
        }
        
        @Override
        public Uint32 getAdminGroup() {
            return _adminGroup;
        }
        
        @Override
        public DecimalBandwidth getAvailableBandwidth() {
            return _availableBandwidth;
        }
        
        @Override
        public Uint32 getBackupAdjSid() {
            return _backupAdjSid;
        }
        
        @Override
        public Uint32 getBackupAdjSid6() {
            return _backupAdjSid6;
        }
        
        @Override
        public Delay getDelay() {
            return _delay;
        }
        
        @Override
        public Delay getJitter() {
            return _jitter;
        }
        
        @Override
        public Ipv4Address getLocalAddress() {
            return _localAddress;
        }
        
        @Override
        public Ipv6Address getLocalAddress6() {
            return _localAddress6;
        }
        
        @Override
        public Uint32 getLocalIdentifier() {
            return _localIdentifier;
        }
        
        @Override
        public Loss getLoss() {
            return _loss;
        }
        
        @Override
        public DecimalBandwidth getMaxLinkBandwidth() {
            return _maxLinkBandwidth;
        }
        
        @Override
        public DecimalBandwidth getMaxResvLinkBandwidth() {
            return _maxResvLinkBandwidth;
        }
        
        @Override
        public Uint32 getMetric() {
            return _metric;
        }
        
        @Override
        public MinMaxDelay getMinMaxDelay() {
            return _minMaxDelay;
        }
        
        @Override
        public Ipv4Address getRemoteAddress() {
            return _remoteAddress;
        }
        
        @Override
        public Ipv6Address getRemoteAddress6() {
            return _remoteAddress6;
        }
        
        @Override
        public Uint32 getRemoteIdentifier() {
            return _remoteIdentifier;
        }
        
        @Override
        public DecimalBandwidth getResidualBandwidth() {
            return _residualBandwidth;
        }
        
        @Override
        public Set<Uint32> getSrlgs() {
            return _srlgs;
        }
        
        @Override
        public Uint32 getTeMetric() {
            return _teMetric;
        }
        
        @Override
        public List<UnreservedBandwidth> getUnreservedBandwidth() {
            return _unreservedBandwidth;
        }
        
        @Override
        public DecimalBandwidth getUtilizedBandwidth() {
            return _utilizedBandwidth;
        }
    
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        @Override
        public MinMaxDelay nonnullMinMaxDelay() {
            return Objects.requireNonNullElse(getMinMaxDelay(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.attributes.MinMaxDelayBuilder.empty());
        }
        
        
        
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = EdgeAttributes.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return EdgeAttributes.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return EdgeAttributes.bindingToString(this);
        }
    }
}
