package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.edge.attributes;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Delay;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;

/**
 * Class that builds {@link MinMaxDelay} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     MinMaxDelay createMinMaxDelay(int fooXyzzy, int barBaz) {
 *         return new MinMaxDelayBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of MinMaxDelay, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see MinMaxDelay
 *
 */
@Generated("mdsal-binding-generator")
public class MinMaxDelayBuilder {

    private Delay _maxDelay;
    private Delay _minDelay;


    Map<Class<? extends Augmentation<MinMaxDelay>>, Augmentation<MinMaxDelay>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public MinMaxDelayBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link MinMaxDelay}.
     *
     * @param base MinMaxDelay from which the builder should be initialized
     */
    public MinMaxDelayBuilder(final MinMaxDelay base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._maxDelay = base.getMaxDelay();
        this._minDelay = base.getMinDelay();
    }


    private static final class LazyEmpty {
        static final @NonNull MinMaxDelay INSTANCE = new MinMaxDelayBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of MinMaxDelay.
     *
     * @return An empty {@link MinMaxDelay}
     */
    public static @NonNull MinMaxDelay empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link MinMaxDelay#getMaxDelay()}.
     *
     * @return current value
     */
    public Delay getMaxDelay() {
        return _maxDelay;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link MinMaxDelay#getMinDelay()}.
     *
     * @return current value
     */
    public Delay getMinDelay() {
        return _minDelay;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<MinMaxDelay>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link MinMaxDelay#getMaxDelay()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public MinMaxDelayBuilder setMaxDelay(final Delay value) {
        this._maxDelay = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link MinMaxDelay#getMinDelay()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public MinMaxDelayBuilder setMinDelay(final Delay value) {
        this._minDelay = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MinMaxDelayBuilder addAugmentation(Augmentation<MinMaxDelay> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MinMaxDelayBuilder removeAugmentation(Class<? extends Augmentation<MinMaxDelay>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link MinMaxDelay} instance.
     *
     * @return A new {@link MinMaxDelay} instance.
     */
    public @NonNull MinMaxDelay build() {
        return new MinMaxDelayImpl(this);
    }

    private static final class MinMaxDelayImpl
        extends AbstractAugmentable<MinMaxDelay>
        implements MinMaxDelay {
    
        private final Delay _maxDelay;
        private final Delay _minDelay;
    
        MinMaxDelayImpl(final MinMaxDelayBuilder base) {
            super(base.augmentation);
            this._maxDelay = base.getMaxDelay();
            this._minDelay = base.getMinDelay();
        }
    
        @Override
        public Delay getMaxDelay() {
            return _maxDelay;
        }
        
        @Override
        public Delay getMinDelay() {
            return _minDelay;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = MinMaxDelay.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return MinMaxDelay.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return MinMaxDelay.bindingToString(this);
        }
    }
}
