package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.Graph;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.YangModuleInfoImpl;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The list of prefixes for the Graph.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * list prefix {
 *   key prefix;
 *   uses prefix;
 * }
 * </pre>
 * <p>To create instances of this class use {@link PrefixBuilder}.
 * @see PrefixBuilder
 * @see PrefixKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Prefix
    extends
    ChildOf<Graph>,
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Prefix,
    EntryObject<Prefix, PrefixKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("prefix");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.Prefix> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.Prefix.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.@NonNull Prefix obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getNodeSid());
        result = prime * result + Objects.hashCode(obj.getPrefix());
        result = prime * result + Objects.hashCode(obj.getPrefixSid());
        result = prime * result + Objects.hashCode(obj.getVertexId());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.@NonNull Prefix thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.Prefix.class, obj);
        return other != null
            && Objects.equals(thisObj.getNodeSid(), other.getNodeSid())
            && Objects.equals(thisObj.getPrefixSid(), other.getPrefixSid())
            && Objects.equals(thisObj.getVertexId(), other.getVertexId())
            && Objects.equals(thisObj.getPrefix(), other.getPrefix())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.@NonNull Prefix obj) {
        final var helper = MoreObjects.toStringHelper("Prefix");
        CodeHelpers.appendValue(helper, "nodeSid", obj.getNodeSid());
        CodeHelpers.appendValue(helper, "prefix", obj.getPrefix());
        CodeHelpers.appendValue(helper, "prefixSid", obj.getPrefixSid());
        CodeHelpers.appendValue(helper, "vertexId", obj.getVertexId());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    PrefixKey key();

}

