/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.graph.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.graph.ConnectedGraph;
import org.opendaylight.graph.ConnectedGraphProvider;
import org.opendaylight.graph.impl.ConnectedGraphImpl;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadWriteTransaction;
import org.opendaylight.mdsal.binding.api.Transaction;
import org.opendaylight.mdsal.binding.api.TransactionChain;
import org.opendaylight.mdsal.binding.api.TransactionChainListener;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.GraphTopology;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.GraphTopologyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.GraphBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.GraphKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Edge;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Vertex;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(immediate=true, service={ConnectedGraphProvider.class})
public final class ConnectedGraphServer
implements ConnectedGraphProvider,
TransactionChainListener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectedGraphServer.class);
    private static final @NonNull InstanceIdentifier<GraphTopology> GRAPH_TOPOLOGY_IDENTIFIER = InstanceIdentifier.create(GraphTopology.class);
    private final Map<GraphKey, ConnectedGraphImpl> graphs = new HashMap<GraphKey, ConnectedGraphImpl>();
    private final DataBroker dataBroker;
    private TransactionChain chain = null;

    @Inject
    @Activate
    public ConnectedGraphServer(@Reference DataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.initTransactionChain();
        this.initOperationalGraphModel();
        LOG.info("Graph Model Server started");
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        this.destroyOperationalGraphModel();
        this.destroyTransactionChain();
    }

    private synchronized void initTransactionChain() {
        LOG.debug("Initializing transaction chain for Graph Model Server {}", (Object)this);
        Preconditions.checkState((this.chain == null ? 1 : 0) != 0, (Object)"Transaction chain has to be closed before being initialized");
        this.chain = this.dataBroker.createMergingTransactionChain((TransactionChainListener)this);
    }

    private synchronized void initOperationalGraphModel() {
        Objects.requireNonNull(this.chain, "A valid transaction chain must be provided.");
        final WriteTransaction trans = this.chain.newWriteOnlyTransaction();
        LOG.info("Create Graph Model at top level in Operational DataStore: {}", GRAPH_TOPOLOGY_IDENTIFIER);
        trans.put(LogicalDatastoreType.OPERATIONAL, GRAPH_TOPOLOGY_IDENTIFIER, (DataObject)new GraphTopologyBuilder().build());
        trans.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("Transaction {} committed successfully", trans.getIdentifier());
            }

            public void onFailure(Throwable throwable) {
                LOG.error("Failed to initialize GraphModel {} (transaction {}) by listener {}", new Object[]{GRAPH_TOPOLOGY_IDENTIFIER, trans.getIdentifier(), ConnectedGraphServer.this, throwable});
            }
        }, MoreExecutors.directExecutor());
    }

    private synchronized FluentFuture<? extends CommitInfo> destroyOperationalGraphModel() {
        Objects.requireNonNull(this.chain, "A valid transaction chain must be provided.");
        final WriteTransaction trans = this.chain.newWriteOnlyTransaction();
        trans.delete(LogicalDatastoreType.OPERATIONAL, GRAPH_TOPOLOGY_IDENTIFIER);
        trans.delete(LogicalDatastoreType.CONFIGURATION, GRAPH_TOPOLOGY_IDENTIFIER);
        FluentFuture future = trans.commit();
        future.addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("Operational GraphModel removed {}", GRAPH_TOPOLOGY_IDENTIFIER);
            }

            public void onFailure(Throwable throwable) {
                LOG.error("Unable to reset operational GraphModel {} (transaction {})", new Object[]{GRAPH_TOPOLOGY_IDENTIFIER, trans.getIdentifier(), throwable});
            }
        }, MoreExecutors.directExecutor());
        for (ConnectedGraph connectedGraph : this.graphs.values()) {
            ((ConnectedGraphImpl)connectedGraph).clear();
        }
        return future;
    }

    private synchronized void destroyTransactionChain() {
        if (this.chain != null) {
            LOG.debug("Destroy transaction chain for GraphModel {}", (Object)this);
            this.chain = null;
        }
    }

    protected synchronized void resetTransactionChain() {
        LOG.debug("Resetting transaction chain for Graph builder");
        this.destroyTransactionChain();
        this.initTransactionChain();
    }

    private static InstanceIdentifier<Graph> getGraphInstanceIdentifier(String name) {
        return GRAPH_TOPOLOGY_IDENTIFIER.child(Graph.class, (Identifier)new GraphKey(name));
    }

    private static InstanceIdentifier<Vertex> getVertexInstanceIdentifier(Graph graph, Vertex vertex) {
        return GRAPH_TOPOLOGY_IDENTIFIER.child(Graph.class, (Identifier)graph.key()).child(Vertex.class, (Identifier)vertex.key());
    }

    private static InstanceIdentifier<Edge> getEdgeInstanceIdentifier(Graph graph, Edge edge) {
        return GRAPH_TOPOLOGY_IDENTIFIER.child(Graph.class, (Identifier)graph.key()).child(Edge.class, (Identifier)edge.key());
    }

    private static InstanceIdentifier<Prefix> getPrefixInstanceIdentifier(Graph graph, Prefix prefix) {
        return GRAPH_TOPOLOGY_IDENTIFIER.child(Graph.class, (Identifier)graph.key()).child(Prefix.class, (Identifier)prefix.key());
    }

    private synchronized <T extends DataObject> void addToDataStore(InstanceIdentifier<T> id, T data, final String info) {
        final ReadWriteTransaction trans = this.chain.newReadWriteTransaction();
        trans.put(LogicalDatastoreType.OPERATIONAL, id, data);
        trans.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.info("GraphModel: {} has been published in operational datastore ", (Object)info);
            }

            public void onFailure(Throwable throwable) {
                LOG.error("GrahModel: Cannot write {} to the operational datastore (transaction: {})", (Object)info, trans.getIdentifier());
            }
        }, MoreExecutors.directExecutor());
    }

    private synchronized <T extends DataObject> void updateToDataStore(InstanceIdentifier<T> id, T data, InstanceIdentifier<T> old, final String info) {
        final ReadWriteTransaction trans = this.chain.newReadWriteTransaction();
        if (old != null) {
            trans.delete(LogicalDatastoreType.OPERATIONAL, old);
        }
        trans.put(LogicalDatastoreType.OPERATIONAL, id, data);
        trans.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.info("GraphModel: {} has been published in operational datastore ", (Object)info);
            }

            public void onFailure(Throwable throwable) {
                LOG.error("GrahModel: Cannot write {} to the operational datastore (transaction: {})", (Object)info, trans.getIdentifier());
            }
        }, MoreExecutors.directExecutor());
    }

    private synchronized <T extends DataObject> void removeFromDataStore(InstanceIdentifier<T> id, final String info) {
        final ReadWriteTransaction trans = this.chain.newReadWriteTransaction();
        trans.delete(LogicalDatastoreType.OPERATIONAL, id);
        trans.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.info("GraphModel: {} has been deleted in operational datastore ", (Object)info);
            }

            public void onFailure(Throwable throwable) {
                LOG.error("GraphModel: Cannot delete {} to the operational datastore (transaction: {})", (Object)info, trans.getIdentifier());
            }
        }, MoreExecutors.directExecutor());
    }

    public void clearGraph(Graph graph) {
        Preconditions.checkArgument((graph != null ? 1 : 0) != 0, (Object)"Provided Graph is a null object");
        this.removeFromDataStore(ConnectedGraphServer.getGraphInstanceIdentifier(graph.getName()), "Graph(" + graph.getName() + ")");
        this.graphs.remove(graph.key());
    }

    public void addVertex(Graph graph, Vertex vertex, Vertex old) {
        Preconditions.checkArgument((graph != null ? 1 : 0) != 0, (Object)"Provided Graph is a null object");
        Preconditions.checkArgument((vertex != null ? 1 : 0) != 0, (Object)"Provided Vertex is a null object");
        InstanceIdentifier<Vertex> oldId = null;
        if (old != null) {
            oldId = ConnectedGraphServer.getVertexInstanceIdentifier(graph, old);
        }
        this.updateToDataStore(ConnectedGraphServer.getVertexInstanceIdentifier(graph, vertex), vertex, oldId, "Vertex(" + vertex.getName() + ")");
    }

    public void deleteVertex(Graph graph, Vertex vertex) {
        Preconditions.checkArgument((graph != null ? 1 : 0) != 0, (Object)"Provided Graph is a null object");
        Preconditions.checkArgument((vertex != null ? 1 : 0) != 0, (Object)"Provided Vertex is a null object");
        this.removeFromDataStore(ConnectedGraphServer.getVertexInstanceIdentifier(graph, vertex), "Vertex(" + vertex.getName() + ")");
    }

    public void addEdge(Graph graph, Edge edge, Edge old) {
        Preconditions.checkArgument((graph != null ? 1 : 0) != 0, (Object)"Provided Graph is a null object");
        Preconditions.checkArgument((edge != null ? 1 : 0) != 0, (Object)"Provided Edge is a null object");
        InstanceIdentifier<Edge> oldId = null;
        if (old != null) {
            oldId = ConnectedGraphServer.getEdgeInstanceIdentifier(graph, old);
        }
        this.updateToDataStore(ConnectedGraphServer.getEdgeInstanceIdentifier(graph, edge), edge, oldId, "Edge(" + edge.getName() + ")");
    }

    public void deleteEdge(Graph graph, Edge edge) {
        Preconditions.checkArgument((graph != null ? 1 : 0) != 0, (Object)"Provided Graph is a null object");
        Preconditions.checkArgument((edge != null ? 1 : 0) != 0, (Object)"Provided Edge is a null object");
        this.removeFromDataStore(ConnectedGraphServer.getEdgeInstanceIdentifier(graph, edge), "Edge(" + edge.getName() + ")");
    }

    public void addPrefix(Graph graph, Prefix prefix) {
        Preconditions.checkArgument((graph != null ? 1 : 0) != 0, (Object)"Provided Graph is a null object");
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"Provided Prefix is a null object");
        this.addToDataStore(ConnectedGraphServer.getPrefixInstanceIdentifier(graph, prefix), prefix, "Prefix(" + prefix.getPrefix() + ")");
    }

    public void deletePrefix(Graph graph, Prefix prefix) {
        Preconditions.checkArgument((graph != null ? 1 : 0) != 0, (Object)"Provided Graph is a null object");
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"Provided Prefix is a null object");
        this.removeFromDataStore(ConnectedGraphServer.getPrefixInstanceIdentifier(graph, prefix), "Prefix(" + prefix.getPrefix() + ")");
    }

    public synchronized void onTransactionChainFailed(TransactionChain transactionChain, Transaction transaction, Throwable cause) {
        LOG.error("GraphModel builder for {} failed in transaction: {} ", new Object[]{GRAPH_TOPOLOGY_IDENTIFIER, transaction != null ? transaction.getIdentifier() : null, cause});
    }

    public void onTransactionChainSuccessful(TransactionChain transactionChain) {
        LOG.info("GraphModel builder for {} shut down", GRAPH_TOPOLOGY_IDENTIFIER);
    }

    public List<ConnectedGraph> getConnectedGraphs() {
        return new ArrayList<ConnectedGraph>(this.graphs.values());
    }

    public ConnectedGraph getConnectedGraph(GraphKey key) {
        return this.graphs.get(key);
    }

    public ConnectedGraph getConnectedGraph(String name) {
        return this.graphs.get(new GraphKey(name));
    }

    public Graph getGraph(GraphKey key) {
        if (this.graphs.containsKey(key)) {
            return this.graphs.get(key).getGraph();
        }
        return null;
    }

    public Graph getGraph(String name) {
        return this.getGraph(new GraphKey(name));
    }

    public ConnectedGraph createConnectedGraph(String name, Graph.DomainScope scope) {
        Graph graph = new GraphBuilder().setName(name).setDomainScope(scope).build();
        this.addToDataStore(ConnectedGraphServer.getGraphInstanceIdentifier(name), graph, "Graph(" + name + ")");
        ConnectedGraphImpl cgraph = new ConnectedGraphImpl(graph, this);
        this.graphs.put(graph.key(), cgraph);
        return cgraph;
    }

    public ConnectedGraph addGraph(Graph graph) {
        Preconditions.checkArgument((graph != null ? 1 : 0) != 0, (Object)"Provided Graph is a null object");
        this.addToDataStore(ConnectedGraphServer.getGraphInstanceIdentifier(graph.getName()), graph, "Graph(" + graph.getName() + ")");
        ConnectedGraphImpl cgraph = new ConnectedGraphImpl(graph, this);
        this.graphs.put(graph.key(), cgraph);
        return cgraph;
    }

    public void deleteGraph(GraphKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Provided Graph Key is a null object");
        ConnectedGraphImpl cgraph = this.graphs.get(key);
        if (cgraph != null) {
            cgraph.clear();
        }
    }
}

