/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.graph.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.graph.ConnectedEdge;
import org.opendaylight.graph.ConnectedEdgeTrigger;
import org.opendaylight.graph.ConnectedGraph;
import org.opendaylight.graph.ConnectedGraphTrigger;
import org.opendaylight.graph.ConnectedVertex;
import org.opendaylight.graph.ConnectedVertexTrigger;
import org.opendaylight.graph.impl.ConnectedEdgeImpl;
import org.opendaylight.graph.impl.ConnectedGraphServer;
import org.opendaylight.graph.impl.ConnectedVertexImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Vertex;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Edge;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.EdgeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.VertexKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectedGraphImpl
implements ConnectedGraph {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectedGraphImpl.class);
    private final HashMap<Long, ConnectedVertexImpl> vertices = new HashMap();
    private final HashMap<Long, ConnectedEdgeImpl> edges = new HashMap();
    private final HashMap<IpPrefix, Prefix> prefixes = new HashMap();
    private final ConcurrentHashMap<TopologyKey, ConnectedGraphTrigger> graphTriggers = new ConcurrentHashMap();
    private final ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    private Graph graph;
    private final ConnectedGraphServer connectedGraphServer;

    public ConnectedGraphImpl(Graph newGraph, ConnectedGraphServer server) {
        this.graph = newGraph;
        this.createConnectedGraph();
        this.connectedGraphServer = server;
    }

    private void createConnectedGraph() {
        ConnectedVertexImpl cvertex;
        if (this.graph == null) {
            return;
        }
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Vertex vertex : this.graph.nonnullVertex().values()) {
            cvertex = new ConnectedVertexImpl(vertex);
            this.vertices.put(cvertex.getKey(), cvertex);
        }
        for (Edge edge : this.graph.nonnullEdge().values()) {
            ConnectedEdgeImpl cedge = new ConnectedEdgeImpl(edge);
            this.edges.put(cedge.getKey(), cedge);
        }
        for (Prefix prefix : this.graph.nonnullPrefix().values()) {
            cvertex = this.vertices.get(prefix.getVertexId().longValue());
            if (cvertex != null) {
                cvertex.addPrefix(prefix);
            }
            this.prefixes.putIfAbsent(prefix.getPrefix(), prefix);
        }
    }

    private ConnectedVertexImpl updateConnectedVertex(@NonNull Long key) {
        Preconditions.checkArgument((key != 0L ? 1 : 0) != 0, (Object)"Provided Vertex Key must not be equal to 0");
        ConnectedVertexImpl vertex = this.vertices.get(key);
        if (vertex == null) {
            vertex = new ConnectedVertexImpl(key);
            this.vertices.put(key, vertex);
        }
        return vertex;
    }

    private ConnectedEdgeImpl updateConnectedEdge(@NonNull Long key) {
        Preconditions.checkArgument((key != 0L ? 1 : 0) != 0, (Object)"Provided Edge Key must not be equal to 0");
        ConnectedEdgeImpl edge = this.edges.get(key);
        if (edge == null) {
            edge = new ConnectedEdgeImpl(key);
            this.edges.put(edge.getKey(), edge);
        }
        return edge;
    }

    private static void connectVertices(ConnectedVertexImpl srcVertex, ConnectedVertexImpl dstVertex, ConnectedEdgeImpl edge) {
        if (edge != null) {
            edge.setSource(srcVertex);
            edge.setDestination(dstVertex);
        }
        if (srcVertex != null) {
            srcVertex.addOutput(edge);
        }
        if (dstVertex != null) {
            dstVertex.addInput(edge);
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    public List<ConnectedVertex> getVertices() {
        return new ArrayList<ConnectedVertex>(this.vertices.values());
    }

    public ConnectedVertex getConnectedVertex(Long key) {
        return this.vertices.get(key);
    }

    public ConnectedVertex getConnectedVertex(IpAddress address) {
        if (address == null) {
            return null;
        }
        IpPrefix prefix = null;
        if (address.getIpv4Address() != null) {
            prefix = new IpPrefix(new Ipv4Prefix(address.getIpv4Address().getValue() + "/32"));
        }
        if (address.getIpv6Address() != null) {
            prefix = new IpPrefix(new Ipv6Prefix(address.getIpv6Address().getValue() + "/128"));
        }
        if (prefix != null && this.prefixes.containsKey(prefix)) {
            long key = this.prefixes.get(prefix).getVertexId().longValue();
            return this.vertices.get(key);
        }
        return null;
    }

    public int getVerticesSize() {
        return this.vertices.size();
    }

    public List<ConnectedEdge> getEdges() {
        return new ArrayList<ConnectedEdge>(this.edges.values());
    }

    public ConnectedEdge getConnectedEdge(Long key) {
        return this.edges.get(key);
    }

    public ConnectedEdge getConnectedEdge(IpAddress address) {
        if (address == null) {
            return null;
        }
        if (address.getIpv4Address() != null) {
            Uint64 key = Uint32.fromIntBits((int)IetfInetUtil.INSTANCE.ipv4AddressBits((Object)address.getIpv4Address())).toUint64();
            return this.getConnectedEdge(key.longValue());
        }
        if (address.getIpv6Address() != null) {
            byte[] ip = IetfInetUtil.INSTANCE.ipv6AddressBytes((Object)address.getIpv6Address());
            Uint64 key = Uint64.fromLongBits((long)ByteBuffer.wrap(ip, 8, 8).getLong());
            return this.getConnectedEdge(key.longValue());
        }
        return null;
    }

    public int getEdgesSize() {
        return this.edges.size();
    }

    public List<Prefix> getPrefixes() {
        return new ArrayList<Prefix>(this.prefixes.values());
    }

    public Prefix getPrefix(IpPrefix prefix) {
        return this.prefixes.get(prefix);
    }

    private void callVertexTrigger(ConnectedVertexImpl cvertex, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Vertex vertex) {
        List<ConnectedVertexTrigger> vertexTriggers = cvertex.getTriggers();
        if (vertexTriggers == null || vertexTriggers.isEmpty()) {
            return;
        }
        for (ConnectedGraphTrigger trigger : this.graphTriggers.values()) {
            this.exec.submit(() -> trigger.verifyVertex((Collection)vertexTriggers, (ConnectedVertex)cvertex, (Vertex)vertex));
        }
    }

    public ConnectedVertex addVertex(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Vertex vertex) {
        Preconditions.checkArgument((vertex != null ? 1 : 0) != 0, (Object)"Provided Vertex is a null object");
        ConnectedVertexImpl cvertex = this.updateConnectedVertex(vertex.getVertexId().longValue());
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Vertex old = cvertex.getVertex();
        this.connectedGraphServer.addVertex(this.graph, vertex, old);
        cvertex.setVertex(vertex);
        if (old != null) {
            this.callVertexTrigger(cvertex, old);
        }
        return cvertex;
    }

    public void deleteVertex(VertexKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Provided Vertex Key is a null object");
        ConnectedVertexImpl cvertex = this.vertices.get(key.getVertexId().longValue());
        if (cvertex != null) {
            cvertex.disconnect();
            this.vertices.remove(cvertex.getKey());
            this.connectedGraphServer.deleteVertex(this.graph, cvertex.getVertex());
            cvertex.setVertex(null);
            this.callVertexTrigger(cvertex, null);
        }
    }

    private void callEdgeTrigger(ConnectedEdgeImpl cedge, Edge edge) {
        List<ConnectedEdgeTrigger> edgeTriggers = cedge.getTriggers();
        if (edgeTriggers == null || edgeTriggers.isEmpty()) {
            return;
        }
        for (ConnectedGraphTrigger trigger : this.graphTriggers.values()) {
            this.exec.submit(() -> trigger.verifyEdge((Collection)edgeTriggers, (ConnectedEdge)cedge, (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Edge)edge));
        }
    }

    public ConnectedEdge addEdge(Edge edge) {
        Preconditions.checkArgument((edge != null ? 1 : 0) != 0, (Object)"Provided Edge is a null object");
        ConnectedEdgeImpl cedge = this.updateConnectedEdge(edge.getEdgeId().longValue());
        Edge old = cedge.getEdge();
        if (old == null) {
            ConnectedVertexImpl source = null;
            ConnectedVertexImpl destination = null;
            if (edge.getLocalVertexId() != null) {
                source = this.updateConnectedVertex(edge.getLocalVertexId().longValue());
            }
            if (edge.getRemoteVertexId() != null) {
                destination = this.updateConnectedVertex(edge.getRemoteVertexId().longValue());
            }
            ConnectedGraphImpl.connectVertices(source, destination, cedge);
        }
        this.connectedGraphServer.addEdge(this.graph, edge, old);
        cedge.setEdge(edge);
        this.callEdgeTrigger(cedge, old);
        return cedge;
    }

    public void deleteEdge(EdgeKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Provided Edge Key is a null object");
        ConnectedEdgeImpl cedge = this.edges.get(key.getEdgeId().longValue());
        if (cedge != null) {
            this.connectedGraphServer.deleteEdge(this.graph, cedge.getEdge());
            cedge.disconnect();
            cedge.setEdge(null);
            this.callEdgeTrigger(cedge, null);
        }
    }

    public void addPrefix(Prefix prefix) {
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"Provided Prefix is a null object");
        ConnectedVertexImpl cvertex = this.updateConnectedVertex(prefix.getVertexId().longValue());
        cvertex.addPrefix(prefix);
        this.prefixes.putIfAbsent(prefix.getPrefix(), prefix);
        this.connectedGraphServer.addPrefix(this.graph, prefix);
    }

    public void deletePrefix(IpPrefix ippfx) {
        Preconditions.checkArgument((ippfx != null ? 1 : 0) != 0, (Object)"Provided Prefix is a null object");
        Prefix prefix = this.prefixes.get(ippfx);
        if (prefix != null) {
            ConnectedVertexImpl cvertex = this.vertices.get(prefix.getVertexId().longValue());
            if (cvertex != null) {
                cvertex.removePrefix(prefix);
            }
            this.prefixes.remove(prefix.getPrefix());
            this.connectedGraphServer.deletePrefix(this.graph, prefix);
        }
    }

    public void clear() {
        LOG.info("Reset Connected Graph({})", (Object)this.graph.getName());
        this.vertices.clear();
        this.edges.clear();
        this.prefixes.clear();
        this.connectedGraphServer.clearGraph(this.graph);
        this.graph = null;
    }

    public String getSummary() {
        return this.vertices.size() + "/" + this.edges.size() + "/" + this.prefixes.size();
    }

    public boolean registerTrigger(ConnectedGraphTrigger trigger, TopologyKey key) {
        return this.graphTriggers.putIfAbsent(key, trigger) == null;
    }

    public boolean unRegisterTrigger(ConnectedGraphTrigger trigger, TopologyKey key) {
        return this.graphTriggers.remove(key, trigger);
    }

    public String toString() {
        return this.graph.getName();
    }
}

