/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.graph.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.graph.ConnectedEdge;
import org.opendaylight.graph.ConnectedVertex;
import org.opendaylight.graph.ConnectedVertexTrigger;
import org.opendaylight.graph.impl.ConnectedEdgeImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Edge;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Vertex;

public class ConnectedVertexImpl
implements ConnectedVertex {
    private ArrayList<ConnectedEdgeImpl> input = new ArrayList();
    private ArrayList<ConnectedEdgeImpl> output = new ArrayList();
    private ArrayList<Prefix> prefixes = new ArrayList();
    private Vertex vertex = null;
    private Long cvid;
    private ConcurrentMap<String, ConnectedVertexTrigger> triggers = new ConcurrentHashMap<String, ConnectedVertexTrigger>();

    public ConnectedVertexImpl(@NonNull Long key) {
        Preconditions.checkArgument((key != 0L ? 1 : 0) != 0, (Object)"Vertex Key must not be equal to 0");
        this.cvid = key;
        this.vertex = null;
    }

    public ConnectedVertexImpl(@NonNull Vertex vertex) {
        Preconditions.checkArgument((vertex.getVertexId().longValue() != 0L ? 1 : 0) != 0, (Object)"Vertex Key must not be equal to 0");
        this.cvid = vertex.getVertexId().longValue();
        this.vertex = vertex;
    }

    void close() {
        this.triggers.clear();
        this.disconnect();
    }

    public ConnectedVertexImpl setVertex(Vertex vertex) {
        this.vertex = vertex;
        return this;
    }

    public ConnectedVertexImpl addInput(ConnectedEdgeImpl edge) {
        if (!this.input.contains(edge)) {
            this.input.add(edge);
        }
        return this;
    }

    public ConnectedVertexImpl addOutput(ConnectedEdgeImpl edge) {
        if (!this.output.contains(edge)) {
            this.output.add(edge);
        }
        return this;
    }

    public ConnectedVertexImpl removeInput(ConnectedEdgeImpl edge) {
        this.input.remove(edge);
        return this;
    }

    public ConnectedVertexImpl removeOutput(ConnectedEdgeImpl edge) {
        this.output.remove(edge);
        return this;
    }

    public void disconnect() {
        for (ConnectedEdgeImpl edge : this.input) {
            edge.disconnectDestination();
        }
        for (ConnectedEdgeImpl edge : this.output) {
            edge.disconnectSource();
        }
    }

    public ConnectedVertexImpl addPrefix(Prefix prefix) {
        if (!this.prefixes.contains(prefix)) {
            this.prefixes.add(prefix);
        }
        return this;
    }

    public void removePrefix(Prefix prefix) {
        if (this.prefixes.contains(prefix)) {
            this.prefixes.remove(prefix);
        }
    }

    public Long getKey() {
        return this.cvid;
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public List<ConnectedEdge> getEdgeTo(Long dstRid) {
        ArrayList<ConnectedEdge> edgeList = new ArrayList<ConnectedEdge>();
        for (ConnectedEdge connectedEdge : this.output) {
            if (!connectedEdge.getDestination().getKey().equals(dstRid)) continue;
            edgeList.add(connectedEdge);
        }
        return edgeList;
    }

    public List<Edge> getInputEdges() {
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        for (ConnectedEdge connectedEdge : this.input) {
            edgeList.add(connectedEdge.getEdge());
        }
        return edgeList;
    }

    public List<ConnectedEdge> getInputConnectedEdges() {
        return new ArrayList<ConnectedEdge>(this.input);
    }

    public List<Edge> getOutputEdges() {
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        for (ConnectedEdge connectedEdge : this.output) {
            edgeList.add(connectedEdge.getEdge());
        }
        return edgeList;
    }

    public List<ConnectedEdge> getOutputConnectedEdges() {
        return new ArrayList<ConnectedEdge>(this.output);
    }

    public List<Prefix> getPrefixes() {
        return this.prefixes;
    }

    public boolean registerTrigger(ConnectedVertexTrigger trigger, String key) {
        return this.triggers.putIfAbsent(key, trigger) == null;
    }

    public boolean unRegisterTrigger(ConnectedVertexTrigger trigger, String key) {
        return this.triggers.remove(key, trigger);
    }

    public List<ConnectedVertexTrigger> getTriggers() {
        return new ArrayList<ConnectedVertexTrigger>(this.triggers.values());
    }

    public String toString() {
        if (this.vertex == null) {
            return "Null";
        }
        if (this.vertex.getName() != null) {
            return this.vertex.getName();
        }
        return this.vertex.getRouterId().toString();
    }
}

