/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.graph.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.graph.ConnectedEdge;
import org.opendaylight.graph.ConnectedEdgeTrigger;
import org.opendaylight.graph.ConnectedVertex;
import org.opendaylight.graph.impl.ConnectedVertexImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.Edge;

public class ConnectedEdgeImpl
implements ConnectedEdge {
    private ConnectedVertexImpl source;
    private ConnectedVertexImpl destination;
    private Edge edge;
    private Long ceid;
    private static int MAX_PRIORITY = 8;
    private Long globalResvBandwidth = 0L;
    private Long[] cosResvBandwidth = new Long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    private ConcurrentMap<String, ConnectedEdgeTrigger> triggers = new ConcurrentHashMap<String, ConnectedEdgeTrigger>();

    public ConnectedEdgeImpl(@NonNull Long key) {
        Preconditions.checkArgument((key != 0L ? 1 : 0) != 0, (Object)"Edge Key must not be equal to 0");
        this.ceid = key;
        this.edge = null;
    }

    public ConnectedEdgeImpl(@NonNull Edge edge) {
        Preconditions.checkArgument((edge.getEdgeId().longValue() != 0L ? 1 : 0) != 0, (Object)"Edge Key must not be equal to 0");
        this.edge = edge;
        this.ceid = edge.getEdgeId().longValue();
    }

    void close() {
        this.triggers.clear();
        this.disconnect();
    }

    public ConnectedEdgeImpl setSource(ConnectedVertexImpl vertex) {
        this.source = vertex;
        return this;
    }

    public ConnectedEdgeImpl setDestination(ConnectedVertexImpl vertex) {
        this.destination = vertex;
        return this;
    }

    public void disconnectSource() {
        if (this.source != null) {
            this.source.removeOutput(this);
            this.source = null;
        }
    }

    public void disconnectDestination() {
        if (this.destination != null) {
            this.destination.removeInput(this);
            this.destination = null;
        }
    }

    public void disconnect() {
        this.disconnectSource();
        this.disconnectDestination();
    }

    public ConnectedEdgeImpl setEdge(Edge edge) {
        this.edge = edge;
        return this;
    }

    public @NonNull Long getKey() {
        return this.ceid;
    }

    public ConnectedVertex getSource() {
        return this.source;
    }

    public ConnectedVertex getDestination() {
        return this.destination;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public Long getGlobalResvBandwidth() {
        return this.globalResvBandwidth;
    }

    public Long getCosResvBandwidth(int cos) {
        if (cos < 0 || cos > MAX_PRIORITY) {
            return null;
        }
        return this.cosResvBandwidth[cos];
    }

    public void addBandwidth(Long bw, int cos) {
        if (cos < 0 || cos > MAX_PRIORITY) {
            return;
        }
        this.globalResvBandwidth = this.globalResvBandwidth + bw;
        Long[] longArray = this.cosResvBandwidth;
        int n = cos;
        Long.valueOf(longArray[n] + bw);
    }

    public void delBandwidth(Long bw, int cos) {
        if (cos < 0 || cos > MAX_PRIORITY) {
            return;
        }
        this.globalResvBandwidth = this.globalResvBandwidth - bw;
        if (this.globalResvBandwidth < 0L) {
            this.globalResvBandwidth = 0L;
        }
        Long[] longArray = this.cosResvBandwidth;
        int n = cos;
        Long.valueOf(longArray[n] - bw);
        if (this.cosResvBandwidth[cos] < 0L) {
            this.cosResvBandwidth[cos] = 0L;
        }
    }

    public boolean registerTrigger(ConnectedEdgeTrigger trigger, String key) {
        return this.triggers.putIfAbsent(key, trigger) == null;
    }

    public boolean unRegisterTrigger(ConnectedEdgeTrigger trigger, String key) {
        return this.triggers.remove(key, trigger);
    }

    public List<ConnectedEdgeTrigger> getTriggers() {
        return new ArrayList<ConnectedEdgeTrigger>(this.triggers.values());
    }

    public String toString() {
        if (this.edge == null) {
            return "Null";
        }
        if (this.edge.getName() != null) {
            return this.edge.getName();
        }
        if (this.edge.getEdgeAttributes() != null) {
            if (this.edge.getEdgeAttributes().getLocalAddress() != null) {
                return this.edge.getEdgeAttributes().getLocalAddress().toString();
            }
            if (this.edge.getEdgeAttributes().getLocalIdentifier() != null) {
                return this.edge.getEdgeAttributes().getLocalIdentifier().toString();
            }
        }
        return "Unknown Edge";
    }
}

