/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.graph.impl;

import java.util.Collection;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.graph.ConnectedGraph;
import org.opendaylight.graph.ConnectedGraphProvider;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.GraphTopology;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.Graph;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.GraphKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.Edge;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.Vertex;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={})
public final class GraphListener
implements DataTreeChangeListener<Graph>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(GraphListener.class);
    private static final InstanceIdentifier<Graph> GRAPH_IDENTIFIER = InstanceIdentifier.builder(GraphTopology.class).child(Graph.class).build();
    private final ConnectedGraphProvider graphProvider;
    private ListenerRegistration<GraphListener> listenerRegistration;

    @Inject
    @Activate
    public GraphListener(@Reference DataBroker dataBroker, @Reference ConnectedGraphProvider provider) {
        this.graphProvider = Objects.requireNonNull(provider);
        this.listenerRegistration = dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, GRAPH_IDENTIFIER), (DataTreeChangeListener)this);
        LOG.info("Registered listener {} on Graph Model at {}", (Object)this, GRAPH_IDENTIFIER);
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        if (this.listenerRegistration != null) {
            LOG.debug("Unregistered listener {} on Graph", (Object)this);
            this.listenerRegistration.close();
            this.listenerRegistration = null;
        }
    }

    private void parseSubTree(ConnectedGraph cgraph, Collection<? extends DataObjectModification<? extends DataObject>> children) {
        for (DataObjectModification<? extends DataObject> dataObjectModification : children) {
            switch (dataObjectModification.getModificationType()) {
                case DELETE: {
                    DataObject value = dataObjectModification.getDataBefore();
                    if (value instanceof Vertex) {
                        cgraph.deleteVertex(((Vertex)value).key());
                    }
                    if (value instanceof Edge) {
                        cgraph.deleteEdge(((Edge)value).key());
                    }
                    if (!(value instanceof Prefix)) break;
                    cgraph.deletePrefix(((Prefix)value).getPrefix());
                    break;
                }
                case SUBTREE_MODIFIED: 
                case WRITE: {
                    DataObject value = dataObjectModification.getDataAfter();
                    if (value instanceof Vertex) {
                        cgraph.addVertex((Vertex)value);
                    }
                    if (value instanceof Edge) {
                        cgraph.addEdge((Edge)value);
                    }
                    if (!(value instanceof Prefix)) break;
                    cgraph.addPrefix((Prefix)value);
                    break;
                }
            }
        }
    }

    public void onDataTreeChanged(Collection<DataTreeModification<Graph>> changes) {
        for (DataTreeModification<Graph> change : changes) {
            DataObjectModification root = change.getRootNode();
            GraphKey key = (GraphKey)change.getRootPath().getRootIdentifier().firstKeyOf(Graph.class);
            switch (root.getModificationType()) {
                case DELETE: {
                    this.graphProvider.deleteGraph(key);
                    break;
                }
                case SUBTREE_MODIFIED: 
                case WRITE: {
                    ConnectedGraph cgraph = this.graphProvider.getConnectedGraph(key);
                    if (cgraph == null) {
                        this.graphProvider.addGraph((Graph)root.getDataAfter());
                        break;
                    }
                    this.parseSubTree(cgraph, root.getModifiedChildren());
                    break;
                }
            }
        }
    }
}

