/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.graph.impl;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.graph.ConnectedGraph;
import org.opendaylight.graph.ConnectedGraphProvider;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.GraphTopology;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.Graph;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.GraphKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.Edge;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.graph.topology.graph.Vertex;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={})
public final class GraphListener
implements DataTreeChangeListener<Graph>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(GraphListener.class);
    private final ConnectedGraphProvider graphProvider;
    private Registration listenerRegistration;

    @Inject
    @Activate
    public GraphListener(@Reference DataBroker dataBroker, @Reference ConnectedGraphProvider provider) {
        this.graphProvider = Objects.requireNonNull(provider);
        InstanceIdentifier graphIdentifier = InstanceIdentifier.builder(GraphTopology.class).child(Graph.class).build();
        this.listenerRegistration = dataBroker.registerLegacyTreeChangeListener(DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)graphIdentifier), (DataTreeChangeListener)this);
        LOG.info("Registered listener {} on Graph Model at {}", (Object)this, (Object)graphIdentifier);
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        if (this.listenerRegistration != null) {
            LOG.debug("Unregistered listener {} on Graph", (Object)this);
            this.listenerRegistration.close();
            this.listenerRegistration = null;
        }
    }

    private static void parseSubTree(ConnectedGraph cgraph, Collection<? extends DataObjectModification<? extends DataObject>> children) {
        block4: for (DataObjectModification<? extends DataObject> dataObjectModification : children) {
            switch (dataObjectModification.modificationType()) {
                case DELETE: {
                    Edge edge;
                    Vertex vertex;
                    DataObject value = dataObjectModification.dataBefore();
                    if (value instanceof Vertex) {
                        vertex = (Vertex)value;
                        cgraph.deleteVertex(vertex.key());
                    }
                    if (value instanceof Edge) {
                        edge = (Edge)value;
                        cgraph.deleteEdge(edge.key());
                    }
                    if (!(value instanceof Prefix)) continue block4;
                    Prefix prefix = (Prefix)value;
                    cgraph.deletePrefix(prefix.getPrefix());
                    break;
                }
                case SUBTREE_MODIFIED: 
                case WRITE: {
                    Edge edge;
                    Vertex vertex;
                    DataObject value = dataObjectModification.dataAfter();
                    if (value instanceof Vertex) {
                        vertex = (Vertex)value;
                        cgraph.addVertex(vertex);
                    }
                    if (value instanceof Edge) {
                        edge = (Edge)value;
                        cgraph.addEdge(edge);
                    }
                    if (!(value instanceof Prefix)) continue block4;
                    Prefix prefix = (Prefix)value;
                    cgraph.addPrefix(prefix);
                    break;
                }
            }
        }
    }

    public void onDataTreeChanged(List<DataTreeModification<Graph>> changes) {
        for (DataTreeModification<Graph> change : changes) {
            DataObjectModification root = change.getRootNode();
            GraphKey key = (GraphKey)change.getRootPath().path().firstKeyOf(Graph.class);
            switch (root.modificationType()) {
                case DELETE: {
                    this.graphProvider.deleteGraph(key);
                    break;
                }
                case SUBTREE_MODIFIED: 
                case WRITE: {
                    ConnectedGraph cgraph = this.graphProvider.getConnectedGraph(key);
                    if (cgraph == null) {
                        this.graphProvider.addGraph((Graph)root.dataAfter());
                        break;
                    }
                    GraphListener.parseSubTree(cgraph, root.modifiedChildren());
                    break;
                }
            }
        }
    }
}

