/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.Subobject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class XroBuilder
implements Builder<Xro> {
    private Xro.Flags _flags;
    private List<Subobject> _subobject;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<Xro>>, Augmentation<Xro>> augmentation = Collections.emptyMap();

    public XroBuilder() {
    }

    public XroBuilder(Object arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public XroBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public XroBuilder(Xro base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Xro>>, Augmentation<Xro>>(aug);
        }
        this._flags = base.getFlags();
        this._subobject = base.getSubobject();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object]");
    }

    public Xro.Flags getFlags() {
        return this._flags;
    }

    public List<Subobject> getSubobject() {
        return this._subobject;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E$$ extends Augmentation<Xro>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public XroBuilder setFlags(Xro.Flags value) {
        this._flags = value;
        return this;
    }

    public XroBuilder setSubobject(List<Subobject> values) {
        this._subobject = values;
        return this;
    }

    public XroBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public XroBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public XroBuilder addAugmentation(Augmentation<Xro> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public XroBuilder addAugmentation(Class<? extends Augmentation<Xro>> augmentationType, Augmentation<Xro> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public XroBuilder removeAugmentation(Class<? extends Augmentation<Xro>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private XroBuilder doAddAugmentation(Class<? extends Augmentation<Xro>> augmentationType, Augmentation<Xro> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Xro>>, Augmentation<Xro>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Xro build() {
        return new XroImpl(this);
    }

    private static final class XroImpl
    extends AbstractAugmentable<Xro>
    implements Xro {
        private final Xro.Flags _flags;
        private final List<Subobject> _subobject;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private int hash = 0;
        private volatile boolean hashValid = false;

        XroImpl(XroBuilder base) {
            super(base.augmentation);
            this._flags = base.getFlags();
            this._subobject = CodeHelpers.emptyToNull(base.getSubobject());
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
        }

        @Override
        public Xro.Flags getFlags() {
            return this._flags;
        }

        @Override
        public List<Subobject> getSubobject() {
            return this._subobject;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._subobject);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Xro.class.equals((java.lang.Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Xro other = (Xro)obj;
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._subobject, other.getSubobject())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                XroImpl otherImpl = (XroImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Xro");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_flags", (java.lang.Object)this._flags);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_subobject", this._subobject);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ignore", (java.lang.Object)this._ignore);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_processingRule", (java.lang.Object)this._processingRule);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (java.lang.Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

