/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.error.object.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class ErrorObjectBuilder
implements Builder<ErrorObject> {
    private Tlvs _tlvs;
    private Uint8 _type;
    private Uint8 _value;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<ErrorObject>>, Augmentation<ErrorObject>> augmentation = Collections.emptyMap();

    public ErrorObjectBuilder() {
    }

    public ErrorObjectBuilder(Object arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public ErrorObjectBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public ErrorObjectBuilder(ErrorObject base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ErrorObject>>, Augmentation<ErrorObject>>(aug);
        }
        this._tlvs = base.getTlvs();
        this._type = base.getType();
        this._value = base.getValue();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object]");
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Uint8 getType() {
        return this._type;
    }

    public Uint8 getValue() {
        return this._value;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E$$ extends Augmentation<ErrorObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ErrorObjectBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public ErrorObjectBuilder setType(Uint8 value) {
        this._type = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public ErrorObjectBuilder setType(Short value) {
        return this.setType(CodeHelpers.compatUint((Short)value));
    }

    public ErrorObjectBuilder setValue(Uint8 value) {
        this._value = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public ErrorObjectBuilder setValue(Short value) {
        return this.setValue(CodeHelpers.compatUint((Short)value));
    }

    public ErrorObjectBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public ErrorObjectBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public ErrorObjectBuilder addAugmentation(Augmentation<ErrorObject> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public ErrorObjectBuilder addAugmentation(Class<? extends Augmentation<ErrorObject>> augmentationType, Augmentation<ErrorObject> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public ErrorObjectBuilder removeAugmentation(Class<? extends Augmentation<ErrorObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private ErrorObjectBuilder doAddAugmentation(Class<? extends Augmentation<ErrorObject>> augmentationType, Augmentation<ErrorObject> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ErrorObject>>, Augmentation<ErrorObject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ErrorObject build() {
        return new ErrorObjectImpl(this);
    }

    private static final class ErrorObjectImpl
    extends AbstractAugmentable<ErrorObject>
    implements ErrorObject {
        private final Tlvs _tlvs;
        private final Uint8 _type;
        private final Uint8 _value;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ErrorObjectImpl(ErrorObjectBuilder base) {
            super(base.augmentation);
            this._tlvs = base.getTlvs();
            this._type = base.getType();
            this._value = base.getValue();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Uint8 getType() {
            return this._type;
        }

        @Override
        public Uint8 getValue() {
            return this._value;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._tlvs);
            result = 31 * result + Objects.hashCode(this._type);
            result = 31 * result + Objects.hashCode(this._value);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ErrorObject.class.equals((java.lang.Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            ErrorObject other = (ErrorObject)obj;
            if (!Objects.equals(this._tlvs, other.getTlvs())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ErrorObjectImpl otherImpl = (ErrorObjectImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"ErrorObject");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_tlvs", (java.lang.Object)this._tlvs);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_type", (java.lang.Object)this._type);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (java.lang.Object)this._value);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ignore", (java.lang.Object)this._ignore);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_processingRule", (java.lang.Object)this._processingRule);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (java.lang.Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

