/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.BandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LoadBalancingObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspaObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2mp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.EndpointRroPair;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.IroBncChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.Metric;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class P2mpBuilder
implements Builder<P2mp> {
    private Bandwidth _bandwidth;
    private List<EndpointRroPair> _endpointRroPair;
    private IroBncChoice _iroBncChoice;
    private LoadBalancing _loadBalancing;
    private Lspa _lspa;
    private List<Metric> _metric;
    private Of _of;
    Map<Class<? extends Augmentation<P2mp>>, Augmentation<P2mp>> augmentation = Collections.emptyMap();

    public P2mpBuilder() {
    }

    public P2mpBuilder(OfObject arg) {
        this._of = arg.getOf();
    }

    public P2mpBuilder(LspaObject arg) {
        this._lspa = arg.getLspa();
    }

    public P2mpBuilder(BandwidthObject arg) {
        this._bandwidth = arg.getBandwidth();
    }

    public P2mpBuilder(LoadBalancingObject arg) {
        this._loadBalancing = arg.getLoadBalancing();
    }

    public P2mpBuilder(P2mp base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<P2mp>>, Augmentation<P2mp>>(aug);
        }
        this._bandwidth = base.getBandwidth();
        this._endpointRroPair = base.getEndpointRroPair();
        this._iroBncChoice = base.getIroBncChoice();
        this._loadBalancing = base.getLoadBalancing();
        this._lspa = base.getLspa();
        this._metric = base.getMetric();
        this._of = base.getOf();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BandwidthObject) {
            this._bandwidth = ((BandwidthObject)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof OfObject) {
            this._of = ((OfObject)arg).getOf();
            isValidArg = true;
        }
        if (arg instanceof LoadBalancingObject) {
            this._loadBalancing = ((LoadBalancingObject)arg).getLoadBalancing();
            isValidArg = true;
        }
        if (arg instanceof LspaObject) {
            this._lspa = ((LspaObject)arg).getLspa();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.BandwidthObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LoadBalancingObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspaObject]");
    }

    public Bandwidth getBandwidth() {
        return this._bandwidth;
    }

    public List<EndpointRroPair> getEndpointRroPair() {
        return this._endpointRroPair;
    }

    public IroBncChoice getIroBncChoice() {
        return this._iroBncChoice;
    }

    public LoadBalancing getLoadBalancing() {
        return this._loadBalancing;
    }

    public Lspa getLspa() {
        return this._lspa;
    }

    public List<Metric> getMetric() {
        return this._metric;
    }

    public Of getOf() {
        return this._of;
    }

    public <E$$ extends Augmentation<P2mp>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public P2mpBuilder setBandwidth(Bandwidth value) {
        this._bandwidth = value;
        return this;
    }

    public P2mpBuilder setEndpointRroPair(List<EndpointRroPair> values) {
        this._endpointRroPair = values;
        return this;
    }

    public P2mpBuilder setIroBncChoice(IroBncChoice value) {
        this._iroBncChoice = value;
        return this;
    }

    public P2mpBuilder setLoadBalancing(LoadBalancing value) {
        this._loadBalancing = value;
        return this;
    }

    public P2mpBuilder setLspa(Lspa value) {
        this._lspa = value;
        return this;
    }

    public P2mpBuilder setMetric(List<Metric> values) {
        this._metric = values;
        return this;
    }

    public P2mpBuilder setOf(Of value) {
        this._of = value;
        return this;
    }

    public P2mpBuilder addAugmentation(Augmentation<P2mp> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public P2mpBuilder addAugmentation(Class<? extends Augmentation<P2mp>> augmentationType, Augmentation<P2mp> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public P2mpBuilder removeAugmentation(Class<? extends Augmentation<P2mp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private P2mpBuilder doAddAugmentation(Class<? extends Augmentation<P2mp>> augmentationType, Augmentation<P2mp> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<P2mp>>, Augmentation<P2mp>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public P2mp build() {
        return new P2mpImpl(this);
    }

    private static final class P2mpImpl
    extends AbstractAugmentable<P2mp>
    implements P2mp {
        private final Bandwidth _bandwidth;
        private final List<EndpointRroPair> _endpointRroPair;
        private final IroBncChoice _iroBncChoice;
        private final LoadBalancing _loadBalancing;
        private final Lspa _lspa;
        private final List<Metric> _metric;
        private final Of _of;
        private int hash = 0;
        private volatile boolean hashValid = false;

        P2mpImpl(P2mpBuilder base) {
            super(base.augmentation);
            this._bandwidth = base.getBandwidth();
            this._endpointRroPair = CodeHelpers.emptyToNull(base.getEndpointRroPair());
            this._iroBncChoice = base.getIroBncChoice();
            this._loadBalancing = base.getLoadBalancing();
            this._lspa = base.getLspa();
            this._metric = CodeHelpers.emptyToNull(base.getMetric());
            this._of = base.getOf();
        }

        @Override
        public Bandwidth getBandwidth() {
            return this._bandwidth;
        }

        @Override
        public List<EndpointRroPair> getEndpointRroPair() {
            return this._endpointRroPair;
        }

        @Override
        public IroBncChoice getIroBncChoice() {
            return this._iroBncChoice;
        }

        @Override
        public LoadBalancing getLoadBalancing() {
            return this._loadBalancing;
        }

        @Override
        public Lspa getLspa() {
            return this._lspa;
        }

        @Override
        public List<Metric> getMetric() {
            return this._metric;
        }

        @Override
        public Of getOf() {
            return this._of;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bandwidth);
            result = 31 * result + Objects.hashCode(this._endpointRroPair);
            result = 31 * result + Objects.hashCode(this._iroBncChoice);
            result = 31 * result + Objects.hashCode(this._loadBalancing);
            result = 31 * result + Objects.hashCode(this._lspa);
            result = 31 * result + Objects.hashCode(this._metric);
            result = 31 * result + Objects.hashCode(this._of);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!P2mp.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            P2mp other = (P2mp)obj;
            if (!Objects.equals(this._bandwidth, other.getBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._endpointRroPair, other.getEndpointRroPair())) {
                return false;
            }
            if (!Objects.equals(this._iroBncChoice, other.getIroBncChoice())) {
                return false;
            }
            if (!Objects.equals(this._loadBalancing, other.getLoadBalancing())) {
                return false;
            }
            if (!Objects.equals(this._lspa, other.getLspa())) {
                return false;
            }
            if (!Objects.equals(this._metric, other.getMetric())) {
                return false;
            }
            if (!Objects.equals(this._of, other.getOf())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                P2mpImpl otherImpl = (P2mpImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"P2mp");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_bandwidth", (Object)this._bandwidth);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_endpointRroPair", this._endpointRroPair);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_iroBncChoice", (Object)this._iroBncChoice);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_loadBalancing", (Object)this._loadBalancing);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_lspa", (Object)this._lspa);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_metric", this._metric);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_of", (Object)this._of);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

