/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTime;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class ProcTimeBuilder
implements Builder<ProcTime> {
    private Uint32 _averageProcTime;
    private Uint32 _currentProcTime;
    private Uint32 _maxProcTime;
    private Uint32 _minProcTime;
    private Uint32 _varianceProcTime;
    private Boolean _estimated;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<ProcTime>>, Augmentation<ProcTime>> augmentation = Collections.emptyMap();

    public ProcTimeBuilder() {
    }

    public ProcTimeBuilder(Object arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public ProcTimeBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public ProcTimeBuilder(ProcTime base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ProcTime>>, Augmentation<ProcTime>>(aug);
        }
        this._averageProcTime = base.getAverageProcTime();
        this._currentProcTime = base.getCurrentProcTime();
        this._maxProcTime = base.getMaxProcTime();
        this._minProcTime = base.getMinProcTime();
        this._varianceProcTime = base.getVarianceProcTime();
        this._estimated = base.isEstimated();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object]");
    }

    public Uint32 getAverageProcTime() {
        return this._averageProcTime;
    }

    public Uint32 getCurrentProcTime() {
        return this._currentProcTime;
    }

    public Uint32 getMaxProcTime() {
        return this._maxProcTime;
    }

    public Uint32 getMinProcTime() {
        return this._minProcTime;
    }

    public Uint32 getVarianceProcTime() {
        return this._varianceProcTime;
    }

    public Boolean isEstimated() {
        return this._estimated;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E$$ extends Augmentation<ProcTime>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ProcTimeBuilder setAverageProcTime(Uint32 value) {
        this._averageProcTime = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public ProcTimeBuilder setAverageProcTime(Long value) {
        return this.setAverageProcTime(CodeHelpers.compatUint((Long)value));
    }

    public ProcTimeBuilder setCurrentProcTime(Uint32 value) {
        this._currentProcTime = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public ProcTimeBuilder setCurrentProcTime(Long value) {
        return this.setCurrentProcTime(CodeHelpers.compatUint((Long)value));
    }

    public ProcTimeBuilder setMaxProcTime(Uint32 value) {
        this._maxProcTime = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public ProcTimeBuilder setMaxProcTime(Long value) {
        return this.setMaxProcTime(CodeHelpers.compatUint((Long)value));
    }

    public ProcTimeBuilder setMinProcTime(Uint32 value) {
        this._minProcTime = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public ProcTimeBuilder setMinProcTime(Long value) {
        return this.setMinProcTime(CodeHelpers.compatUint((Long)value));
    }

    public ProcTimeBuilder setVarianceProcTime(Uint32 value) {
        this._varianceProcTime = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public ProcTimeBuilder setVarianceProcTime(Long value) {
        return this.setVarianceProcTime(CodeHelpers.compatUint((Long)value));
    }

    public ProcTimeBuilder setEstimated(Boolean value) {
        this._estimated = value;
        return this;
    }

    public ProcTimeBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public ProcTimeBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public ProcTimeBuilder addAugmentation(Augmentation<ProcTime> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public ProcTimeBuilder addAugmentation(Class<? extends Augmentation<ProcTime>> augmentationType, Augmentation<ProcTime> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public ProcTimeBuilder removeAugmentation(Class<? extends Augmentation<ProcTime>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private ProcTimeBuilder doAddAugmentation(Class<? extends Augmentation<ProcTime>> augmentationType, Augmentation<ProcTime> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ProcTime>>, Augmentation<ProcTime>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ProcTime build() {
        return new ProcTimeImpl(this);
    }

    private static final class ProcTimeImpl
    extends AbstractAugmentable<ProcTime>
    implements ProcTime {
        private final Uint32 _averageProcTime;
        private final Uint32 _currentProcTime;
        private final Uint32 _maxProcTime;
        private final Uint32 _minProcTime;
        private final Uint32 _varianceProcTime;
        private final Boolean _estimated;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ProcTimeImpl(ProcTimeBuilder base) {
            super(base.augmentation);
            this._averageProcTime = base.getAverageProcTime();
            this._currentProcTime = base.getCurrentProcTime();
            this._maxProcTime = base.getMaxProcTime();
            this._minProcTime = base.getMinProcTime();
            this._varianceProcTime = base.getVarianceProcTime();
            this._estimated = base.isEstimated();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
        }

        @Override
        public Uint32 getAverageProcTime() {
            return this._averageProcTime;
        }

        @Override
        public Uint32 getCurrentProcTime() {
            return this._currentProcTime;
        }

        @Override
        public Uint32 getMaxProcTime() {
            return this._maxProcTime;
        }

        @Override
        public Uint32 getMinProcTime() {
            return this._minProcTime;
        }

        @Override
        public Uint32 getVarianceProcTime() {
            return this._varianceProcTime;
        }

        @Override
        public Boolean isEstimated() {
            return this._estimated;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._averageProcTime);
            result = 31 * result + Objects.hashCode(this._currentProcTime);
            result = 31 * result + Objects.hashCode(this._maxProcTime);
            result = 31 * result + Objects.hashCode(this._minProcTime);
            result = 31 * result + Objects.hashCode(this._varianceProcTime);
            result = 31 * result + Objects.hashCode(this._estimated);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ProcTime.class.equals((java.lang.Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            ProcTime other = (ProcTime)obj;
            if (!Objects.equals(this._averageProcTime, other.getAverageProcTime())) {
                return false;
            }
            if (!Objects.equals(this._currentProcTime, other.getCurrentProcTime())) {
                return false;
            }
            if (!Objects.equals(this._maxProcTime, other.getMaxProcTime())) {
                return false;
            }
            if (!Objects.equals(this._minProcTime, other.getMinProcTime())) {
                return false;
            }
            if (!Objects.equals(this._varianceProcTime, other.getVarianceProcTime())) {
                return false;
            }
            if (!Objects.equals(this._estimated, other.isEstimated())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ProcTimeImpl otherImpl = (ProcTimeImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"ProcTime");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_averageProcTime", (java.lang.Object)this._averageProcTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_currentProcTime", (java.lang.Object)this._currentProcTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maxProcTime", (java.lang.Object)this._maxProcTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_minProcTime", (java.lang.Object)this._minProcTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_varianceProcTime", (java.lang.Object)this._varianceProcTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_estimated", (java.lang.Object)this._estimated);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ignore", (java.lang.Object)this._ignore);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_processingRule", (java.lang.Object)this._processingRule);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (java.lang.Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

