package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.config;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.PcepConfig;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * PCEP topology config
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-config</b>
 * <pre>
 * container session-config {
 *   leaf rpc-timeout {
 *     type int16;
 *     default 30;
 *     units seconds;
 *   }
 *   leaf listen-address {
 *     type inet:ip-address-no-zone;
 *     default 0.0.0.0;
 *   }
 *   leaf listen-port {
 *     type inet:port-number;
 *     default 4189;
 *   }
 *   leaf dead-timer-value {
 *     type uint16;
 *     default 120;
 *     units seconds;
 *   }
 *   leaf keep-alive-timer-value {
 *     type uint16;
 *     default 30;
 *     units seconds;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-configpcep-configsession-config</i>
 *
 * <p>To create instances of this class use {@link SessionConfigBuilder}.
 * @see SessionConfigBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface SessionConfig
    extends
    ChildOf<PcepConfig>,
    Augmentable<SessionConfig>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("session-config");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.config.SessionConfig> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.config.SessionConfig.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.config.@NonNull SessionConfig obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getDeadTimerValue());
        result = prime * result + Objects.hashCode(obj.getKeepAliveTimerValue());
        result = prime * result + Objects.hashCode(obj.getListenAddress());
        result = prime * result + Objects.hashCode(obj.getListenPort());
        result = prime * result + Objects.hashCode(obj.getRpcTimeout());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.config.@NonNull SessionConfig thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.config.SessionConfig other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.config.SessionConfig.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getDeadTimerValue(), other.getDeadTimerValue())) {
            return false;
        }
        if (!Objects.equals(thisObj.getKeepAliveTimerValue(), other.getKeepAliveTimerValue())) {
            return false;
        }
        if (!Objects.equals(thisObj.getListenPort(), other.getListenPort())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRpcTimeout(), other.getRpcTimeout())) {
            return false;
        }
        if (!Objects.equals(thisObj.getListenAddress(), other.getListenAddress())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.config.@NonNull SessionConfig obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SessionConfig");
        CodeHelpers.appendValue(helper, "deadTimerValue", obj.getDeadTimerValue());
        CodeHelpers.appendValue(helper, "keepAliveTimerValue", obj.getKeepAliveTimerValue());
        CodeHelpers.appendValue(helper, "listenAddress", obj.getListenAddress());
        CodeHelpers.appendValue(helper, "listenPort", obj.getListenPort());
        CodeHelpers.appendValue(helper, "rpcTimeout", obj.getRpcTimeout());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return rpcTimeout, or {@code null} if it is not present.
     *
     * @return {@code Short} rpcTimeout, or {@code null} if it is not present.
     *
     */
    Short getRpcTimeout();
    
    /**
     * Return rpcTimeout, guaranteed to be non-null.
     *
     * @return {@code Short} rpcTimeout, guaranteed to be non-null.
     * @throws NoSuchElementException if rpcTimeout is not present
     *
     */
    default @NonNull Short requireRpcTimeout() {
        return CodeHelpers.require(getRpcTimeout(), "rpctimeout");
    }
    
    /**
     * Return listenAddress, or {@code null} if it is not present.
     *
     * @return {@code IpAddressNoZone} listenAddress, or {@code null} if it is not present.
     *
     */
    IpAddressNoZone getListenAddress();
    
    /**
     * Return listenAddress, guaranteed to be non-null.
     *
     * @return {@code IpAddressNoZone} listenAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if listenAddress is not present
     *
     */
    default @NonNull IpAddressNoZone requireListenAddress() {
        return CodeHelpers.require(getListenAddress(), "listenaddress");
    }
    
    /**
     * Return listenPort, or {@code null} if it is not present.
     *
     * @return {@code PortNumber} listenPort, or {@code null} if it is not present.
     *
     */
    PortNumber getListenPort();
    
    /**
     * Return listenPort, guaranteed to be non-null.
     *
     * @return {@code PortNumber} listenPort, guaranteed to be non-null.
     * @throws NoSuchElementException if listenPort is not present
     *
     */
    default @NonNull PortNumber requireListenPort() {
        return CodeHelpers.require(getListenPort(), "listenport");
    }
    
    /**
     * Return deadTimerValue, or {@code null} if it is not present.
     *
     * @return {@code Uint16} deadTimerValue, or {@code null} if it is not present.
     *
     */
    Uint16 getDeadTimerValue();
    
    /**
     * Return deadTimerValue, guaranteed to be non-null.
     *
     * @return {@code Uint16} deadTimerValue, guaranteed to be non-null.
     * @throws NoSuchElementException if deadTimerValue is not present
     *
     */
    default @NonNull Uint16 requireDeadTimerValue() {
        return CodeHelpers.require(getDeadTimerValue(), "deadtimervalue");
    }
    
    /**
     * Return keepAliveTimerValue, or {@code null} if it is not present.
     *
     * @return {@code Uint16} keepAliveTimerValue, or {@code null} if it is not present.
     *
     */
    Uint16 getKeepAliveTimerValue();
    
    /**
     * Return keepAliveTimerValue, guaranteed to be non-null.
     *
     * @return {@code Uint16} keepAliveTimerValue, guaranteed to be non-null.
     * @throws NoSuchElementException if keepAliveTimerValue is not present
     *
     */
    default @NonNull Uint16 requireKeepAliveTimerValue() {
        return CodeHelpers.require(getKeepAliveTimerValue(), "keepalivetimervalue");
    }

}

