package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.node.config;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.rfc2385.cfg.rev160324.Rfc2385Key;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.PcepNodeConfig;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-config</b>
 * <pre>
 * container session-config {
 *   leaf password {
 *     type rfc2385:rfc2385-key;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-configpcep-node-configsession-config</i>
 *
 * <p>To create instances of this class use {@link SessionConfigBuilder}.
 * @see SessionConfigBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface SessionConfig
    extends
    ChildOf<PcepNodeConfig>,
    Augmentable<SessionConfig>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("session-config");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.node.config.SessionConfig> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.node.config.SessionConfig.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.node.config.@NonNull SessionConfig obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getPassword());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.node.config.@NonNull SessionConfig thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.node.config.SessionConfig other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.node.config.SessionConfig.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getPassword(), other.getPassword())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev200120.pcep.node.config.@NonNull SessionConfig obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SessionConfig");
        CodeHelpers.appendValue(helper, "password", obj.getPassword());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return password, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         RFC2385 shared secret
     *     </code>
     * </pre>
     *
     * @return {@code Rfc2385Key} password, or {@code null} if it is not present.
     *
     */
    Rfc2385Key getPassword();
    
    /**
     * Return password, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         RFC2385 shared secret
     *     </code>
     * </pre>
     *
     * @return {@code Rfc2385Key} password, guaranteed to be non-null.
     * @throws NoSuchElementException if password is not present
     *
     */
    default @NonNull Rfc2385Key requirePassword() {
        return CodeHelpers.require(getPassword(), "password");
    }

}

