package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcmonrep.message.PcmonrepMessage;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PcmonrepBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PcmonrepBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PcmonrepBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PcmonrepBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PcmonrepBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PcmonrepBuilder implements Builder<Pcmonrep> {

    private PcmonrepMessage _pcmonrepMessage;


    Map<Class<? extends Augmentation<Pcmonrep>>, Augmentation<Pcmonrep>> augmentation = Collections.emptyMap();

    public PcmonrepBuilder() {
    }
    
    
    
    
    public PcmonrepBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PcmonrepMessage arg) {
        this._pcmonrepMessage = arg.getPcmonrepMessage();
    }
    public PcmonrepBuilder(Message arg) {
    }

    public PcmonrepBuilder(Pcmonrep base) {
        Map<Class<? extends Augmentation<Pcmonrep>>, Augmentation<Pcmonrep>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._pcmonrepMessage = base.getPcmonrepMessage();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PcmonrepMessage</li>
     * <li>Message</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PcmonrepMessage) {
            this._pcmonrepMessage = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PcmonrepMessage)arg).getPcmonrepMessage();
            isValidArg = true;
        }
        if (arg instanceof Message) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PcmonrepMessage, Message]");
    }

    public PcmonrepMessage getPcmonrepMessage() {
        return _pcmonrepMessage;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Pcmonrep>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public PcmonrepBuilder setPcmonrepMessage(final PcmonrepMessage value) {
        this._pcmonrepMessage = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PcmonrepBuilder addAugmentation(Augmentation<Pcmonrep> augmentation) {
        Class<? extends Augmentation<Pcmonrep>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PcmonrepBuilder removeAugmentation(Class<? extends Augmentation<Pcmonrep>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Pcmonrep build() {
        return new PcmonrepImpl(this);
    }

    private static final class PcmonrepImpl
        extends AbstractAugmentable<Pcmonrep>
        implements Pcmonrep {
    
        private final PcmonrepMessage _pcmonrepMessage;
    
        PcmonrepImpl(PcmonrepBuilder base) {
            super(base.augmentation);
            this._pcmonrepMessage = base.getPcmonrepMessage();
        }
    
        @Override
        public PcmonrepMessage getPcmonrepMessage() {
            return _pcmonrepMessage;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Pcmonrep.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Pcmonrep.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Pcmonrep.bindingToString(this);
        }
    }
}
