package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * PCEP Error-type/value.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-session-stats</b>
 * <pre>
 * grouping error {
 *   leaf error-type {
 *     type uint8;
 *     default 0;
 *   }
 *   leaf error-value {
 *     type uint8;
 *     default 0;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-session-statserror</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface Error
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("error");

    @Override
    Class<? extends Error> implementedInterface();
    
    /**
     * Return errorType, or {@code null} if it is not present.
     *
     * @return {@code Uint8} errorType, or {@code null} if it is not present.
     *
     */
    Uint8 getErrorType();
    
    /**
     * Return errorType, guaranteed to be non-null.
     *
     * @return {@code Uint8} errorType, guaranteed to be non-null.
     * @throws NoSuchElementException if errorType is not present
     *
     */
    default @NonNull Uint8 requireErrorType() {
        return CodeHelpers.require(getErrorType(), "errortype");
    }
    
    /**
     * Return errorValue, or {@code null} if it is not present.
     *
     * @return {@code Uint8} errorValue, or {@code null} if it is not present.
     *
     */
    Uint8 getErrorValue();
    
    /**
     * Return errorValue, guaranteed to be non-null.
     *
     * @return {@code Uint8} errorValue, guaranteed to be non-null.
     * @throws NoSuchElementException if errorValue is not present
     *
     */
    default @NonNull Uint8 requireErrorValue() {
        return CodeHelpers.require(getErrorValue(), "errorvalue");
    }

}

