package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.Messages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.PeerCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.PeerPref;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * PCEP session statistics.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-session-stats</b>
 * <pre>
 * grouping pcep-session-state {
 *   leaf session-duration {
 *     type string;
 *   }
 *   leaf synchronized {
 *     type boolean;
 *     default false;
 *   }
 *   container peer-capabilities {
 *   }
 *   container messages {
 *     uses reply-time-grouping;
 *     leaf received-msg-count {
 *       type uint32;
 *       default 0;
 *     }
 *     leaf sent-msg-count {
 *       type uint32;
 *       default 0;
 *     }
 *     leaf last-sent-msg-timestamp {
 *       type uint32;
 *       default 0;
 *     }
 *     leaf unknown-msg-received {
 *       type uint16;
 *       default 0;
 *     }
 *     uses error-messages-grouping;
 *   }
 *   container local-pref {
 *     uses preferences;
 *   }
 *   container peer-pref {
 *     uses preferences;
 *   }
 *   leaf delegated-lsps-count {
 *     type uint16;
 *     default 0;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-session-statspcep-session-state</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface PcepSessionState
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("pcep-session-state");

    @Override
    Class<? extends PcepSessionState> implementedInterface();
    
    /**
     * Return sessionDuration, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Elapsed time (in d:H:m:s) from session-up until now.
     *     </code>
     * </pre>
     *
     * @return {@code String} sessionDuration, or {@code null} if it is not present.
     *
     */
    String getSessionDuration();
    
    /**
     * Return sessionDuration, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Elapsed time (in d:H:m:s) from session-up until now.
     *     </code>
     * </pre>
     *
     * @return {@code String} sessionDuration, guaranteed to be non-null.
     * @throws NoSuchElementException if sessionDuration is not present
     *
     */
    default @NonNull String requireSessionDuration() {
        return CodeHelpers.require(getSessionDuration(), "sessionduration");
    }
    
    /**
     * Return synchronized, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Represents synchronization status.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} synchronized, or {@code null} if it is not present.
     *
     */
    Boolean getSynchronized();
    
    /**
     * Return synchronized, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Represents synchronization status.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} synchronized, guaranteed to be non-null.
     * @throws NoSuchElementException if synchronized is not present
     *
     */
    default @NonNull Boolean requireSynchronized() {
        return CodeHelpers.require(getSynchronized(), "synchronized");
    }
    
    /**
     * Return peerCapabilities, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Remote peer's (PCC) advertised capabilities.
     *     </code>
     * </pre>
     *
     * @return {@code PeerCapabilities} peerCapabilities, or {@code null} if it is not present.
     *
     */
    PeerCapabilities getPeerCapabilities();
    
    /**
     * Return messages, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The statistics of PCEP received/sent messages from the PCE point of view.
     *     </code>
     * </pre>
     *
     * @return {@code Messages} messages, or {@code null} if it is not present.
     *
     */
    Messages getMessages();
    
    /**
     * Return localPref, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The local (PCE) preferences.
     *     </code>
     * </pre>
     *
     * @return {@code LocalPref} localPref, or {@code null} if it is not present.
     *
     */
    LocalPref getLocalPref();
    
    /**
     * Return peerPref, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The remote peer (PCC) preferences.
     *     </code>
     * </pre>
     *
     * @return {@code PeerPref} peerPref, or {@code null} if it is not present.
     *
     */
    PeerPref getPeerPref();
    
    /**
     * Return delegatedLspsCount, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The number of delegated LSPs (tunnels) from PCC.
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} delegatedLspsCount, or {@code null} if it is not present.
     *
     */
    Uint16 getDelegatedLspsCount();
    
    /**
     * Return delegatedLspsCount, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The number of delegated LSPs (tunnels) from PCC.
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} delegatedLspsCount, guaranteed to be non-null.
     * @throws NoSuchElementException if delegatedLspsCount is not present
     *
     */
    default @NonNull Uint16 requireDelegatedLspsCount() {
        return CodeHelpers.require(getDelegatedLspsCount(), "delegatedlspscount");
    }

}

