package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-session-stats</b>
 * <pre>
 * grouping preferences {
 *   leaf keepalive {
 *     type uint8;
 *     default 0;
 *   }
 *   leaf deadtimer {
 *     type uint8;
 *     default 0;
 *   }
 *   leaf ip-address {
 *     type string;
 *     default "";
 *   }
 *   leaf session-id {
 *     type uint16;
 *     default 0;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-session-statspreferences</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface Preferences
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("preferences");

    @Override
    Class<? extends Preferences> implementedInterface();
    
    /**
     * Return keepalive, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Advertised keep-alive value.
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} keepalive, or {@code null} if it is not present.
     *
     */
    Uint8 getKeepalive();
    
    /**
     * Return keepalive, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Advertised keep-alive value.
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} keepalive, guaranteed to be non-null.
     * @throws NoSuchElementException if keepalive is not present
     *
     */
    default @NonNull Uint8 requireKeepalive() {
        return CodeHelpers.require(getKeepalive(), "keepalive");
    }
    
    /**
     * Return deadtimer, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Advertised deadtimer value.
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} deadtimer, or {@code null} if it is not present.
     *
     */
    Uint8 getDeadtimer();
    
    /**
     * Return deadtimer, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Advertised deadtimer value.
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} deadtimer, guaranteed to be non-null.
     * @throws NoSuchElementException if deadtimer is not present
     *
     */
    default @NonNull Uint8 requireDeadtimer() {
        return CodeHelpers.require(getDeadtimer(), "deadtimer");
    }
    
    /**
     * Return ipAddress, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Peer's IP address.
     *     </code>
     * </pre>
     *
     * @return {@code String} ipAddress, or {@code null} if it is not present.
     *
     */
    String getIpAddress();
    
    /**
     * Return ipAddress, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Peer's IP address.
     *     </code>
     * </pre>
     *
     * @return {@code String} ipAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if ipAddress is not present
     *
     */
    default @NonNull String requireIpAddress() {
        return CodeHelpers.require(getIpAddress(), "ipaddress");
    }
    
    /**
     * Return sessionId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Peer's session identifier.
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} sessionId, or {@code null} if it is not present.
     *
     */
    Uint16 getSessionId();
    
    /**
     * Return sessionId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Peer's session identifier.
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} sessionId, guaranteed to be non-null.
     * @throws NoSuchElementException if sessionId is not present
     *
     */
    default @NonNull Uint16 requireSessionId() {
        return CodeHelpers.require(getSessionId(), "sessionid");
    }

}

