package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.ErrorMessagesGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.error.messages.LastReceivedError;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.error.messages.LastSentError;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * The message statistics of received/sent PCErr messages.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-session-stats</b>
 * <pre>
 * container error-messages {
 *   leaf received-error-msg-count {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf sent-error-msg-count {
 *     type uint32;
 *     default 0;
 *   }
 *   container last-received-error {
 *     uses error;
 *   }
 *   container last-sent-error {
 *     uses error;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-session-statserror-messages-groupingerror-messages</i>
 *
 * <p>To create instances of this class use {@link ErrorMessagesBuilder}.
 * @see ErrorMessagesBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface ErrorMessages
    extends
    ChildOf<ErrorMessagesGrouping>,
    Augmentable<ErrorMessages>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("error-messages");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.ErrorMessages> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.ErrorMessages.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.@NonNull ErrorMessages obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getLastReceivedError());
        result = prime * result + Objects.hashCode(obj.getLastSentError());
        result = prime * result + Objects.hashCode(obj.getReceivedErrorMsgCount());
        result = prime * result + Objects.hashCode(obj.getSentErrorMsgCount());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.@NonNull ErrorMessages thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.ErrorMessages other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.ErrorMessages.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getReceivedErrorMsgCount(), other.getReceivedErrorMsgCount())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSentErrorMsgCount(), other.getSentErrorMsgCount())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLastReceivedError(), other.getLastReceivedError())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLastSentError(), other.getLastSentError())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.@NonNull ErrorMessages obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ErrorMessages");
        CodeHelpers.appendValue(helper, "lastReceivedError", obj.getLastReceivedError());
        CodeHelpers.appendValue(helper, "lastSentError", obj.getLastSentError());
        CodeHelpers.appendValue(helper, "receivedErrorMsgCount", obj.getReceivedErrorMsgCount());
        CodeHelpers.appendValue(helper, "sentErrorMsgCount", obj.getSentErrorMsgCount());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return receivedErrorMsgCount, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Total number of received PCErr messages.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} receivedErrorMsgCount, or {@code null} if it is not present.
     *
     */
    Uint32 getReceivedErrorMsgCount();
    
    /**
     * Return receivedErrorMsgCount, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Total number of received PCErr messages.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} receivedErrorMsgCount, guaranteed to be non-null.
     * @throws NoSuchElementException if receivedErrorMsgCount is not present
     *
     */
    default @NonNull Uint32 requireReceivedErrorMsgCount() {
        return CodeHelpers.require(getReceivedErrorMsgCount(), "receivederrormsgcount");
    }
    
    /**
     * Return sentErrorMsgCount, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Total number of sent PCErr messages.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} sentErrorMsgCount, or {@code null} if it is not present.
     *
     */
    Uint32 getSentErrorMsgCount();
    
    /**
     * Return sentErrorMsgCount, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Total number of sent PCErr messages.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} sentErrorMsgCount, guaranteed to be non-null.
     * @throws NoSuchElementException if sentErrorMsgCount is not present
     *
     */
    default @NonNull Uint32 requireSentErrorMsgCount() {
        return CodeHelpers.require(getSentErrorMsgCount(), "senterrormsgcount");
    }
    
    /**
     * Return lastReceivedError, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Type/value tuple of last received error.
     *     </code>
     * </pre>
     *
     * @return {@code LastReceivedError} lastReceivedError, or {@code null} if it is not present.
     *
     */
    LastReceivedError getLastReceivedError();
    
    /**
     * Return lastSentError, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Type/value tuple of last sent error.
     *     </code>
     * </pre>
     *
     * @return {@code LastSentError} lastSentError, or {@code null} if it is not present.
     *
     */
    LastSentError getLastSentError();

}

