package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.error.messages.LastReceivedError;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.error.messages.LastSentError;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link ErrorMessagesBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ErrorMessagesBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new ErrorMessagesBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ErrorMessagesBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ErrorMessagesBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class ErrorMessagesBuilder implements Builder<ErrorMessages> {

    private LastReceivedError _lastReceivedError;
    private LastSentError _lastSentError;
    private Uint32 _receivedErrorMsgCount;
    private Uint32 _sentErrorMsgCount;


    Map<Class<? extends Augmentation<ErrorMessages>>, Augmentation<ErrorMessages>> augmentation = Collections.emptyMap();

    public ErrorMessagesBuilder() {
    }
    
    

    public ErrorMessagesBuilder(ErrorMessages base) {
        Map<Class<? extends Augmentation<ErrorMessages>>, Augmentation<ErrorMessages>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._lastReceivedError = base.getLastReceivedError();
        this._lastSentError = base.getLastSentError();
        this._receivedErrorMsgCount = base.getReceivedErrorMsgCount();
        this._sentErrorMsgCount = base.getSentErrorMsgCount();
    }


    public LastReceivedError getLastReceivedError() {
        return _lastReceivedError;
    }
    
    public LastSentError getLastSentError() {
        return _lastSentError;
    }
    
    public Uint32 getReceivedErrorMsgCount() {
        return _receivedErrorMsgCount;
    }
    
    public Uint32 getSentErrorMsgCount() {
        return _sentErrorMsgCount;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ErrorMessages>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public ErrorMessagesBuilder setLastReceivedError(final LastReceivedError value) {
        this._lastReceivedError = value;
        return this;
    }
    
    public ErrorMessagesBuilder setLastSentError(final LastSentError value) {
        this._lastSentError = value;
        return this;
    }
    
    public ErrorMessagesBuilder setReceivedErrorMsgCount(final Uint32 value) {
        this._receivedErrorMsgCount = value;
        return this;
    }
    
    public ErrorMessagesBuilder setSentErrorMsgCount(final Uint32 value) {
        this._sentErrorMsgCount = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ErrorMessagesBuilder addAugmentation(Augmentation<ErrorMessages> augmentation) {
        Class<? extends Augmentation<ErrorMessages>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ErrorMessagesBuilder removeAugmentation(Class<? extends Augmentation<ErrorMessages>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ErrorMessages build() {
        return new ErrorMessagesImpl(this);
    }

    private static final class ErrorMessagesImpl
        extends AbstractAugmentable<ErrorMessages>
        implements ErrorMessages {
    
        private final LastReceivedError _lastReceivedError;
        private final LastSentError _lastSentError;
        private final Uint32 _receivedErrorMsgCount;
        private final Uint32 _sentErrorMsgCount;
    
        ErrorMessagesImpl(ErrorMessagesBuilder base) {
            super(base.augmentation);
            this._lastReceivedError = base.getLastReceivedError();
            this._lastSentError = base.getLastSentError();
            this._receivedErrorMsgCount = base.getReceivedErrorMsgCount();
            this._sentErrorMsgCount = base.getSentErrorMsgCount();
        }
    
        @Override
        public LastReceivedError getLastReceivedError() {
            return _lastReceivedError;
        }
        
        @Override
        public LastSentError getLastSentError() {
            return _lastSentError;
        }
        
        @Override
        public Uint32 getReceivedErrorMsgCount() {
            return _receivedErrorMsgCount;
        }
        
        @Override
        public Uint32 getSentErrorMsgCount() {
            return _sentErrorMsgCount;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ErrorMessages.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ErrorMessages.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ErrorMessages.bindingToString(this);
        }
    }
}
