package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.error.messages;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.Error;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link LastSentErrorBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     LastSentErrorBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new LastSentErrorBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of LastSentErrorBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see LastSentErrorBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class LastSentErrorBuilder implements Builder<LastSentError> {

    private Uint8 _errorType;
    private Uint8 _errorValue;


    Map<Class<? extends Augmentation<LastSentError>>, Augmentation<LastSentError>> augmentation = Collections.emptyMap();

    public LastSentErrorBuilder() {
    }
    
    
    
    public LastSentErrorBuilder(Error arg) {
        this._errorType = arg.getErrorType();
        this._errorValue = arg.getErrorValue();
    }

    public LastSentErrorBuilder(LastSentError base) {
        Map<Class<? extends Augmentation<LastSentError>>, Augmentation<LastSentError>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._errorType = base.getErrorType();
        this._errorValue = base.getErrorValue();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>Error</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Error) {
            this._errorType = ((Error)arg).getErrorType();
            this._errorValue = ((Error)arg).getErrorValue();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Error]");
    }

    public Uint8 getErrorType() {
        return _errorType;
    }
    
    public Uint8 getErrorValue() {
        return _errorValue;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<LastSentError>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public LastSentErrorBuilder setErrorType(final Uint8 value) {
        this._errorType = value;
        return this;
    }
    
    public LastSentErrorBuilder setErrorValue(final Uint8 value) {
        this._errorValue = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public LastSentErrorBuilder addAugmentation(Augmentation<LastSentError> augmentation) {
        Class<? extends Augmentation<LastSentError>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public LastSentErrorBuilder removeAugmentation(Class<? extends Augmentation<LastSentError>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public LastSentError build() {
        return new LastSentErrorImpl(this);
    }

    private static final class LastSentErrorImpl
        extends AbstractAugmentable<LastSentError>
        implements LastSentError {
    
        private final Uint8 _errorType;
        private final Uint8 _errorValue;
    
        LastSentErrorImpl(LastSentErrorBuilder base) {
            super(base.augmentation);
            this._errorType = base.getErrorType();
            this._errorValue = base.getErrorValue();
        }
    
        @Override
        public Uint8 getErrorType() {
            return _errorType;
        }
        
        @Override
        public Uint8 getErrorValue() {
            return _errorValue;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = LastSentError.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return LastSentError.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return LastSentError.bindingToString(this);
        }
    }
}
